<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.6 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Хåե
 */
ob_start();
/**
 * magic_quotes_runtime -> off
 */
set_magic_quotes_runtime(0);
/**
 * PHPƥ२顼¸
 */
if (SYL_CONFIG_SYSTEM_ERROR_LOG && is_writable(dirname(SYL_CONFIG_SYSTEM_ERROR_LOG_FILE))) {
    ini_set('log_errors', SYL_CONFIG_SYSTEM_ERROR_LOG);
    ini_set('error_log', SYL_CONFIG_SYSTEM_ERROR_LOG_FILE);
}

/**
 * եɤ߹९饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_DefinesReader.php';
/**
 * ƥʥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Container.php';

/**
 * ƥ⥳ȥ̾
 */
define('SYL_CONFIG_CONTROLLER_NAME', 'controller');

/**
 * ȥ饯饹
 *
 * Τνή
 * Ƥ
 *   DIƥʤݻ
 *   ήȼܥ٥Ƚ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.6 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Controller
{
    /**
     * ǥ쥯ȥ롼
     *
     * @access private
     * @var string
     */
    var $action_dir = '';
    /**
     * ƥץ졼ȥǥ쥯ȥ롼
     *
     * @access private
     * @var string
     */
    var $template_dir = '';
    /**
     * ե̾
     *
     * @access private
     * @var string
     */
    var $defines_file_name = 'defines.xml';
    /**
     * ݡͥե̾
     *
     * @access protected
     * @var string
     */
    var $components_file_name = 'components.xml';
    /**
     * ƥʥ֥
     *
     * @access private
     * @var object
     */
    var $container = null;
    /**
     * ˴᥽å̾
     * ''ξϽ˴᥽åɤưʤ
     *
     * @access private
     * @var string
     */
    var $destory_method = 'finalStream';
    /**
     * ˴֥
     *
     * @access private
     * @var array
     */
    var $destory_objects = array();

    /**
     * ȥ
     *
     * ¹ԴĶˤꡢWEB or CmdΥȥȽꤷƼ
     *
     * @access public
     * @param array Ķ
     */
    function &getController($config)
    {
        static $singleton;
        if (!is_object($singleton)) {
            if ((PHP_SAPI == 'cli') || ((PHP_SAPI == 'cgi') && !isset($_SERVER['REQUEST_METHOD']))) {
                define('SYL_ENV_TYPE', 'cmd');
            } else {
                define('SYL_ENV_TYPE', 'web');
            }
            $class_name = 'SyL_Controller' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Controller/{$class_name}.php";
            // ҥ饹Υ󥹥
            $singleton = new $class_name($config);
        }
        return $singleton;
    }

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param array Ķ
     */
    function SyL_Controller($config)
    {
        // ץꥱ̾
        if (!isset($config['app_name']) || !$config['app_name']) {
            trigger_error("[SyL error] Controller parameter app_name not exists", E_USER_ERROR);
        }

        // ǥХå٥
        define('SYL_DEBUG', (isset($config['debug']) && is_numeric($config['debug'])) ? $config['debug'] : SYL_LOG_NOTICE);
        // WEBץꥱǥ쥯ȥ
        define('SYL_WEBAPP_DIR', (isset($config['webapp_dir']) && $config['webapp_dir']) ? $config['webapp_dir'] : SYL_DIR . '/webapp');
        // å
        define('SYL_WEBAPP_CACHE_DIR', (isset($config['cache_dir']) && $config['cache_dir']) ? SYL_WEBAPP_DIR . $config['cache_dir'] : false);
        // WEBץꥱեǥ쥯ȥ
        define('SYL_WEBAPP_CONFIG_DIR',  SYL_WEBAPP_DIR . '/config');
        // WEBץꥱ饤֥ǥ쥯ȥ
        define('SYL_WEBAPP_LIB_DIR',  SYL_WEBAPP_DIR . '/lib');
        // ץꥱǥ쥯ȥ
        define('SYL_APP_DIR', SYL_WEBAPP_DIR . '/app/' . $config['app_name']);

        // ɤ߹
        SyL_DefinesReader::readConfig($this, $this->defines_file_name);

        // shutdownϥɥ
        if ($this->destory_method != '') {
            register_shutdown_function(array(&$this, $this->destory_method));
        }

        // ǥ쥯ȥ
        $this->action_dir = SYL_APP_DIR . '/actions';
        // ƥץ졼ȥǥ쥯ȥ
        $this->template_dir = SYL_APP_DIR . '/templates';

        // ƥ
        $this->container =& new SyL_Container();
        $this->container->setComponent(SYL_CONFIG_CONTROLLER_NAME, $this);
    }

    /**
     * 
     *
     * @access protected
     */
    function initStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('initStream');
    }

    /**
     * ¹
     *
     * @access protected
     */
    function loadStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('loadStream');
    }

    /**
     * ¹
     *
     * @access protected
     */
    function executeStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('executeStream');
    }

    /**
     * ӥ塼ɽ¹
     *
     * @access protected
     */
    function middleStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('middleStream');
    }

    /**
     * ӥ塼ɽ
     *
     * @access protected
     */
    function renderStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('renderStream');
    }

    /**
     * ӥ塼ɽ¹Ը
     *
     * @access protected
     */
    function unloadStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('unloadStream');
    }

    /**
     * ǽ
     * register_shutdown_function
     *
     * @access protected
     */
    function finalStream()
    {
        // ٥ȼ¹
        if (is_object($this->container)) {
            $this->raiseEvent('finalStream');
        }
    }

    /**
     * ȥݥ
     *
     * @access public
     */
    function stream()
    {
    }

    /**
     * ٥ȼ¹
     *
     * @access protected
     * @param string ٥ȥ᥽å̾
     * @param string ե̾
     */
    function raiseEvent($event, $config_type=array())
    {
        $this->container->raiseEvent($event, $config_type);
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ
     */
    function getActionDir()
    {
        return $this->action_dir;
    }
}

?>
