<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Error.php,v 1.6 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Loggers.php';

/**
 * 顼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Error.php,v 1.6 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Error
{
    /**
     * 顼å
     * 
     * @var array
     */
    var $error_message = array();
    /**
     * ϥɥ᥽å̾
     * 
     * @var string
     */
    var $handler_method = 'errorHandler';
    /**
     * ԥ
     * 
     * @access public
     * @var string
     */
    var $eof = "\r\n";

    /**
     * SyL_Error饹Υ󥹥󥹼
     *
     * singletonǥѤƤΤǡ
     * 1ĤΥ󥹥󥹤λȤ롣
     *
     * ˡ
     *   $SyL_Error =& SyL_Error::getInstance();
     *
     * @access public
     * @param string 顼
     */
    function &getInstance()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $class_name = 'SyL_Error' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Error/{$class_name}.php";
            // ҥ饹Υ󥹥
            $singleton = new $class_name();
            // 顼ϥɥ饻å
            call_user_func(array($singleton, 'setErrorHandler'));
        }
        return $singleton;
    }

    /**
     * 顼å򥻥å
     * 
     * @static
     * @access public
     * @param string 顼å
     */
    function setErrorMessage($error_message)
    {
        $e =& SyL_Error::getInstance();
        $e->error_message[] = $error_message;
    }

    /**
     * Ǥ̥顼̤ɽ
     * 
     * @static
     * @access public
     * @param string 顼å
     * @param int 顼٥
     */
    function trigger($error_string='', $error_type=E_USER_ERROR)
    {
        trigger_error($error_string, $error_type);
    }

    /**
     * 顼ϥɥ
     * 
     * @static
     * @access public
     */
    function setErrorHandler()
    {
        $e =& SyL_Error::getInstance();
        set_error_handler(array(&$e, $e->handler_method));
    }

    /**
     * 顼ϥɥ
     * 
     * @static
     * @access public
     */
    function resetErrorHandler()
    {
        restore_error_handler();
    }

    /**
     * 顼ϥɥ顼μ
     * 
     * Loding Frameworkǥեȥ顼̤ܤȤ
     * Ѥ롣
     *
     * @access abstruct
     * @param  int 顼No
     * @param  string 顼å
     */
    function errorHandler( $error_no, $error_string ) {}

    /**
     * 顼פ֤
     * ºݤ˥ץǥϥɥ󥰤ǤΤ
     *   E_WARNING
     *   E_NOTICE
     *   E_USER_ERROR
     *   E_USER_WARNING
     *   E_USER_NOTICE
     * Τ
     *
     * @access public
     * @param  int    顼No
     * @return string 顼̾
     */
    function getErrorType($errorNo)
    {
        switch ($errorNo) {
        case E_ERROR           : return 'Error';
        case E_WARNING         : return 'Warning';
        case E_PARSE           : return 'Parsing Error';
        case E_NOTICE          : return 'Notice';
        case E_CORE_ERROR      : return 'Core Error';
        case E_CORE_WARNING    : return 'Core Warning';
        case E_COMPILE_ERROR   : return 'Compile Error';
        case E_COMPILE_WARNING : return 'Compile Warning';
        case E_USER_ERROR      : return 'User Error';
        case E_USER_WARNING    : return 'User Warning';
        case E_USER_NOTICE     : return 'User Notice';
        default:
          if (defined('E_STRICT') && ($errorNo == E_STRICT)) return 'Strict';
          if (defined('E_RECOVERABLE_ERROR') && ($errorNo == E_RECOVERABLE_ERROR)) return 'Recoverable Error';
        }

        return 'Unknonwn';
    }

    /**
     * ȥ졼
     *
     * @access public
     * @return array ȥ졼
     */
    function getTrace()
    {
        // 顼ȥ졼
        $error_trace = array();
        foreach (array_reverse(debug_backtrace()) as $value) {
            // 桼顼ϡtrigger_error״ؿʹߤӽ
            // ¾Υ顼ϡerrorhandler״ؿʹߤӽ
            if (isset($value['class']) && (strtolower($value['class']) == strtolower(get_class($this)))) {
                break;
            }
            $tmp = array();
            $tmp['file']     = isset($value['file'])     ? $value['file']     : '';
            $tmp['line']     = isset($value['line'])     ? $value['line']     : '';
            if (isset($value['class']) && isset($value['type'])) {
                $tmp['function'] = $value['class'] . $value['type'] . $value['function'];
            } else {
                $tmp['function'] = isset($value['function']) ? $value['function'] : '';
            }
            $error_trace[] = $tmp;
        }

        return array_reverse($error_trace);
    }

    /**
     * 󥰤¸
     *
     * @access public
     * @param int 顼No
     * @param string 顼å
     */
    function logging($error_no, $error_message)
    {
        if (class_exists('SyL_Loggers') && ($error_no <= SYL_DEBUG)) {
            $log_string  = '[' . $this->getErrorType($error_no) . '] ' . $error_message . $this->eof;
            foreach ($this->getTrace() as $value) {
                $log_string .= "[file] "     . $value['file'] . " ";
                $log_string .= "[line] "     . $value['line'] . " ";
                $log_string .= "[function] " . $value['function'] . $this->eof;
            }

            // 顼٥˥¸
            switch ($error_no) {
            case E_WARNING:
            case E_USER_WARNING:
                SyL_Loggers::warn($log_string);
                break;
            case E_NOTICE:
            case E_USER_NOTICE:
                SyL_Loggers::notice($log_string);
                break;
            default:
                SyL_Loggers::error($log_string);
                break;
            }
        }
    }
}

?>
