<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Pgsql.php,v 1.6 2006/12/19 13:28:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹PostgreSQL
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Pgsql.php,v 1.6 2006/12/19 13:28:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DB_Pgsql extends SyL_DB
{
    /**
     * 󥳡Ѵơ֥
     *
     *  PostgreSQL <=> PHP
     *  (client)       (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    var $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'euc-jp'),
      array('euc-jp',    'euc-jp'),
      array('sjis-win',  'sjis' ),
      array('sjis-win',  'mskanji'),
      array('sjis-win',  'shiftjis'),
      array('sjis-win',  'win932'),
      array('sjis-win',  'windows932'),
      array('sjis',      'sjis'),
      array('utf-8',     'utf8'),
      array('utf-8',     'unicode')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $conn_array   = array();
        $conn_array[] = 'dbname=' . $dbname;
        $conn_array[] = 'user='   . $user;
        if ($passwd != '') {
            $conn_array[] = 'password=' . $passwd;
        }
        if ($host != '') {
            $conn_array[] = 'host=' . $host;
        }
        if ($port != '') {
            $conn_array[] = 'port=' . $port;
        }
        $conn_string = implode(' ', $conn_array);

        $this->connection = ($persistent) ? pg_pconnect($conn_string) : pg_connect($conn_string);
        if (is_resource($this->connection)) {
            $this->setClientEncoding();
            return true;
        } else {
            return false;
        }
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            pg_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string ʸ
     */
    function setClientEncoding($client_encode='')
    {
        parent::setClientEncoding($client_encode);
        if ($this->client_encode) {
            pg_set_client_encoding($this->connection, $this->client_encode);
        }
    }

    /**
     * Ǹ˵ä顼å
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function getLastError()
    {
        return pg_last_error($this->connection);
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function sanitize($parameter)
    {
        return !is_numeric($parameter) ? pg_escape_string($parameter) : $parameter;
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function begin()
    {
        parent::begin();
        @pg_query($this->connection, 'BEGIN');
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollback()
    {
        @pg_query($this->connection, 'ROLLBACK');
        parent::rollback();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        @pg_query($this->connection, 'COMMIT');
        parent::commit();
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function executeSelect($sql)
    {
        $result = @pg_query($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function executeUpdate($sql)
    {
        // ¹Ի顼Ƚ
        $result = @pg_query($this->connection, $sql);
        if ($result !== false) {
            return pg_affected_rows($result);
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeNoReturn($sql)
    {
        // ¹Ի顼Ƚ
        $result = @pg_query($this->connection, $sql);
        if ($result !== false) {
            return true;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }
  
    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeGet($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execute($sql, $query);
  
        // ¹Ի顼Ƚ
        if (is_resource($query)) {
            switch ($get) {
            // 1ե
            case 'one':
                if (pg_num_rows($query) > 0) {
                    list($data) = pg_fetch_row($query);
                } else {
                    $data = '';
                }
                break;
            // 1쥳
            case 'record':
                $data = pg_fetch_assoc($query);
                if ($data === false) {
                    $data = array();
                } else {
                    $data = $this->changeFieldName($data);
                }
                break;
            // 쥳
            case 'all':
                $data = array();
                while ($result = pg_fetch_assoc($query)) {
                    $data[] = $this->changeFieldName($result);
                }
                break;
            }
            pg_free_result($query);
            return true;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     * ¹ˡinitializePageץ᥽åɼ¹ɬ
     * SQLʸΡFROM׶ľ˥ʸɬܡʤʳΥʸԲġ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function executePage($sql, &$result, &$page_control, $limit, $page=1)
    {
        // ڡ楯饹
        include_once dirname(dirname(__FILE__)) . '/SyL_Pager.php';
        $page_control = new SyL_Pager();
        $page_control->setCount($limit);
        $page_control->setPage($page);

        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->executeGet($sql_count, $record, 'one')) return false;
        $page_control->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= " LIMIT "  . $page_control->getCount();
        $sql_page .= " OFFSET " . $page_control->getStartRecord();

        // ǡSQL¹
        return $this->executeGet($sql_page, $result, 'all');
    }

    /**
     * եեޥåȴؿ̾
     *
     * @access public
     *
     * @param string ̾
     * @param string շեޥå  YYYY/MM/DD YYYY/MM/DD HH24:MI:SS
     * @return string եեޥåȴؿ̾
     */
    function getSqlDateFormat($column_name, $format='YYYY-MM-DD HH24:MI:SS')
    {
        return "TO_DATE('{$column_name}', '{$format}')";
    }
}

?>
