<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Console.php,v 1.2 2006/12/19 13:28:23 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  󥽡ɽ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Console.php,v 1.2 2006/12/19 13:28:23 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Console
{
    /**
     * ɸ
     *
     * @access private
     * @var resource
     */
    var $stdin;
    /**
     * ɸ
     *
     * @access private
     * @var resource
     */
    var $stdout;
    /**
     * ɸ२顼
     *
     * @access private
     * @var resource
     */
    var $stderr;
    /**
     * 
     *
     * @access private
     * @var array
     */
    var $args = array();
    /**
     * ȤƼ¹ԤȤΰ
     * falseξϥޥɼ¹Բ
     *
     * @access private
     * @var array
     */
    var $shell_string = '\!';
    /**
     * ¹Ի˥ޥɥ饤λʸ
     *
     * @access private
     * @var array
     */
    var $exit_strings = array(
      'quit',
      'exit',
      '\q'
    );
    /**
     * ޥɥ饤ɽå
     *
     * [message]
     * [default_message] > 
     *
     * array(
     *   [0] => array( [message], [default_message] ),
     *   ...
     * );
     *
     * @access private
     * @var array
     */
    var $command_messages = array();
    /**
     * ޥɥ饤󤫤ͤ륳Хåؿ
     *
     * @access private
     * @var array
     */
    var $callback_func = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Console()
    {
        // Ȥꤢ˴
        while (@ob_end_clean());

        ob_start();
        $this->stdin  = fopen('php://stdin',  'r');
        $this->stdout = fopen('php://stdout', 'w');
        $this->stderr = fopen('php://stderr', 'w');

        $this->callback_func = array(&$this, 'doCallback');
        $this->args =  $_SERVER['argv'];
    }

    /**
     * ¸ߤ뤫Ƚꤹ
     *
     * @access public
     * @param string 
     * @return mixed 
     */
    function isArg($arg)
    {
        return in_array($arg, $this->args);
    }

    /**
     * 
     * ʸ䡢Ƭˡ-פդƤϡץ󤫤
     *
     * @access public
     * @param string 
     * @return mixed 
     */
    function getArg($arg=null)
    {
        $return = '';
        if ($arg === null) {
            // ץ̵
            $return = array();
            $match = 1;
            for ($i=1; $i<$this->getArgCount(); $i++) {
                if ((substr($this->args[$i], 0, 1) != '-') && ($match >= 1)) {
                    $return[] = $this->args[$i];
                }
                $match = (substr($this->args[$i], 0, 1) == '-') ? 0 : $match + 1;
            }

        } else if ((substr($arg, 0, 1) == '-') || !is_numeric($arg)) {
            // ץ󤢤
            $return = array();
            if (substr($arg, 0, 1) != '-') {
                $arg = '-' . $arg;
            }

            $match = false;
            for ($i=1; $i<$this->getArgCount(); $i++) {
                if ($this->args[$i] == $arg) {
                    $match = false;
                }
                if ($match) {
                    $return[] = $this->args[$i];
                }
                $match = !$match && ($this->args[$i] == $arg);
            }

        } else {
            // ͻ
            if (isset($this->args[$arg])) {
                $return = $this->args[$arg];
            }
        }

        return $return;
    }

    /**
     * 
     *
     * @access public
     * @return array 
     */
    function getArgs()
    {
        return $this->args;
    }

    /**
     * ο
     *
     * @access public
     * @return int ο
     */
    function getArgCount()
    {
        return count($this->args);
    }

    /**
     * λʸɲä
     *
     * @access public
     * @param string λʸ
     */
    function addExitString($exit_string)
    {
        $this->exit_strings[] = $exit_string;
    }

    /**
     * ʸѹ
     * falseξϥޥɼ¹Բ
     *
     * @access public
     * @param string ʸ
     */
    function setShellString($shell_string)
    {
        $this->shell_string = $shell_string;
    }

    /**
     * ¹ѡɽå򥻥å
     *
     * @access public
     * @param string ɽå
     * @param string ޥ­å
     */
    function setMessage($message, $message_default='')
    {
        $this->command_messages[] = array($message, $message_default);
    }

    /**
     * ¹ѡޥɥ饤󤫤ͤ륳Хåؿ򥻥å
     *
     * @access public
     * @param mixed Хåؿ
     */
    function setCallbackFunc($callback_func)
    {
        if (is_callable($callback_func)) {
            $this->callback_func = $callback_func;
        } else {
            trigger_error("[SyL error] invalid callable format", E_USER_ERROR);
        }
    }

    /**
     * ǥեȥХåؿ
     *
     * @access public
     * @param string 
     */
    function doCallback(&$console, $return, $shell)
    {
    }

    /**
     * ¹ԥ
     *
     * @access public
     * @param bool ޥɥ롼ץե饰
     */
    function start($loop=false)
    {
        while (true) {
            $shell = false;
            if ($this->command_messages) {
                $command_message = array_shift($this->command_messages);
                $return = $this->getInput($command_message[0], $command_message[1]);
            } else {
                if (!$loop) {
                    break;
                }
                $return = $this->getInput('');
            }
            if (in_array($return, $this->exit_strings)) {
                break;
            }
            if ($this->shell_string && (substr($return, 0, strlen($this->shell_string)) == $this->shell_string)) {
                $shell = true;
                $return = shell_exec(substr($return, strlen($this->shell_string)));
            }
            // Хåؿ¹
            call_user_func_array($this->callback_func, array(&$this, $return, $shell));
        }
    }

    /**
     * ɽϤ
     *
     * @access public
     * @param string ɽå
     * @param bool ԥե饰
     */
    function stdout($message, $newline=true)
    {
       if ($newline) {
           $message .= "\n";
       }
       fwrite($this->stdout, $message);
    }

    /**
     * 顼ɽϤ
     *
     * @access public
     * @param string 顼ɽå
     * @param bool ԥե饰
     */
    function stderr($message, $newline=true)
    {
       if ($newline) {
           $message .= "\n";
       }
       fwrite($this->stderr, $message);
    }

    /**
     * ͤ
     *
     * @access public
     * @param string ɽå
     * @param string ޥ­å
     */
    function getInput($message, $message_default='')
    {
        if ($message_default != '') {
            $message_default .= ' ';
        }
        $message_default .= '> ';
        if ($message) {
            $this->stdout($message);
        }
        $this->stdout($message_default, false);

        ob_flush();
        return trim(fgets($this->stdin,256));
    }
    
}

?>
