<?php
/**
 * ץȥǥ쥯ȥݡͥȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: C_CreateProject.php,v 1.2 2006/12/19 13:29:02 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class C_CreateProject
{
    /**
     * ץȥǥ쥯ȥ
     *
     * @access public
     * @param string ץȥǥ쥯ȥ
     */
    function trigger($project_dir)
    {
        if (!is_dir($project_dir)) {
            if (!mkdir($project_dir, 0755)) {
                trigger_error("[SyL error] Project directory can't create ({$project_dir})", E_USER_ERROR);
                exit;
            }
        }

        $dirs = array(
          'app'       => 0755,
          'config'    => 0755,
          'lib'       => 0755,
          'var'       => 0755,
          'var/logs'  => 0777,
          'var/cache' => 0777,
          'var/skel-templates'  => 0777,
          'var/smarty' => 0777
        );

        foreach ($dirs as $dir => $mode) {
            if (!is_dir($project_dir . $dir)) {
                echo "  creating directory {$project_dir}{$dir}\n"; ob_flush();
                mkdir("{$project_dir}{$dir}", $mode);
            }
        }

        echo "  copying file {$project_dir}config/defines.xml\n"; ob_flush();
        copy(SYL_WEBAPP_DIR . '/var/skel-templates/defines.xml', "{$project_dir}config/defines.xml");
        echo "  copying file {$project_dir}config/filters.xml\n"; ob_flush();
        copy(SYL_WEBAPP_DIR . '/var/skel-templates/filters.xml', "{$project_dir}config/filters.xml");
        echo "  copying file {$project_dir}config/components.xml\n"; ob_flush();
        copy(SYL_WEBAPP_DIR . '/var/skel-templates/components.xml', "{$project_dir}config/components.xml");

        $dh = opendir(SYL_WEBAPP_DIR . '/var/skel-templates/');
        while (($file = readdir($dh)) !== false) {
            if ($file != '.' && $file != '..') {
                $basefile = $file;
                echo "  copying file {$project_dir}var/skel-templates/{$file}\n"; ob_flush();
                copy(SYL_WEBAPP_DIR . "/var/skel-templates/{$file}", "{$project_dir}var/skel-templates/{$file}");
            }
        }
        closedir($dh);
    }
}

?>
