<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestParameterSession.php,v 1.1 2006/12/23 11:12:21 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥ᡼ݻ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_RequestParameter.php';

/**
 * åݻ饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestParameterSession.php,v 1.1 2006/12/23 11:12:21 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RequestParameterSession extends SyL_RequestParameter
{
    /**
     * DBå󥪥֥
     *
     * @access private
     * @var object
     */
    var $session_db = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RequestParameterSession()
    {
        if (!isset($_SESSION)) {
            // å̾򥻥å
            if (SYL_SESSION_NAME != '') {
                session_name(SYL_SESSION_NAME);
            }
            // åѹ
            if (SYL_SESSION_CACHE != '') {
                session_cache_limiter(SYL_SESSION_CACHE);
            }
            // åƼѥ᡼
            $session_path   = (SYL_SESSION_PATH != '')   ? SYL_SESSION_PATH   : '/';
            $session_domain = (SYL_SESSION_DOMAIN != '') ? SYL_SESSION_DOMAIN : null;
            $session_secure = (SYL_SESSION_SECURE) ? true : false;
            session_set_cookie_params(0, $session_path, $session_domain, $session_secure);

            // PHP 4.3.3 ʹ
            //session_regenerate_id();

            if (strtolower(SYL_SESSION_TYPE) == 'db') {
                // DBå
                include_once SYL_INCLUDE_DIR . '/framework/RequestParameter/SyL_SessionDB.php';
                $this->session_db =& new SyL_SessionDB();
            } else {
                // ǥեȥå
                session_start();
            }

            $this->parameters =& $_SESSION;
        }
    }

    /**
     * ѥ᡼
     * 
     * @access public
     */
    function deleteParameterAll()
    {
        parent::deleteParameterAll();
        if (isset($_COOKIE[session_name()])) {
           setcookie(session_name(), '', time()-42000, SYL_SESSION_PATH);
        }
        session_destroy();
    }

    /**
     * åλ
     * 
     * @access public
     */
    function closeSession()
    {
        session_write_close();
    }

    /**
     * åID
     * 
     * @access public
     * @return mixed åID
     */
    function getSID()
    {
        return urlencode(session_id());
    }

    /**
     * ѥ᡼̾եåID
     * 
     * @access public
     * @return mixed ѥ᡼̾եåID
     */
    function getSIDQuery()
    {
        return urlencode(session_name()) . '=' . urlencode(session_id());
    }
}

?>
