<?php
/**
 * ץȺ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: defaultcommand.php,v 1.3 2006/12/23 11:14:31 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class DefaultCommand
{
    var $version   = SYL_VERSION;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function DefaultCommand()
    {
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     * @param object ݡͥȥ᥽åɥ֥
     */
    function execute(&$cmd, &$cm)
    {
        // С󥳥ޥ
        if ($cmd->isArg('-h') || $cmd->isArg('--help')) {
            $this->displayHelp($cmd);
        // إץޥ
        } else if ($cmd->isArg('-v') || $cmd->isArg('--version')) {
            $this->displayVersion($cmd);
        } else {
            $this->displayDefault($cmd);
        }
    }

    /**
     * إפɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function displayHelp(&$cmd)
    {
        $file = basename($cmd->getArg(0));
        $help = <<<EOF
Usage:
  {$file} project [or pro] -d <dir> -w <name> [-c]
  {$file} application [or app] -d <dir> -w <name> [-c]
  {$file} controller [or con] -d <dir> -w <name> -c <file>
  {$file} action [or act] -d <dir> -w <name> -a <name>
  {$file} template [or tem] -d <dir> -w <name> -t <name>
  {$file} [option]

Options:
  -d <dir>  project directory
  -w <name> application name
  -c <file> front controller file
  -a <name> action file (path from action directory)
  -t <name> template file (path from template directory)
  -h        show this help, then exit
  -v        output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function displayVersion(&$cmd)
    {
        $file = basename($cmd->getArg(0));
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$this->version} (on PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (c) 2006 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function displayDefault(&$cmd)
    {
        $file = basename($cmd->getArg(0));
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
