<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.8 2006/12/25 17:30:18 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEB̥顼ɽ饹
 *
 * 顼åɽѥ
 * ư顼1
 *   ̥顼ɽ
 *   end( '顼å' )
 * 
 * ư顼2
 *   ̥顼̤˥顼åߤơ쵤ɽ
 *   
 *   end(顼å֥)
 * 
 * ư顼
 *   顼ϥɥ
 *   ̥顼ɽ塢λ
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.8 2006/12/25 17:30:18 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorWeb extends SyL_Error
{
    /**
     * 顼ϥɥ顼μ
     * 
     * @access public
     * @param object ǡ֥
     */
    function errorHandler(&$dm)
    {
        // Хåե󥰥ꥢ
        // ɬ
        ob_clean();

        // 顼å
        $error_message = implode('<br>', $this->getErrorMessages());
        // 顼פμ
        $error_type  = $this->getErrorType();
        // 顼ȥ졼μ
        $error_trace = SYL_ERROR_TRACE ? $this->getTraceHtml() : '';

        // 顼ɽȽ
        $error_View_type = explode('-', SYL_ERROR_FORWARD_TYPE);
        switch (strtolower($error_View_type[0])) {
        case 'template': $error_View_type[0] = 'Template'; break;
        case 'redirect': $error_View_type[0] = 'Redirect'; break;
        default:         $error_View_type[0] = 'Default';  break;
        }

        if (!isset($error_View_type[1])) {
            $error_View_type[1] = '';
        }

        // 顼ɽ
        $func_name = "displayError{$error_View_type[0]}";
        // 顼å
        $error_string = SYL_ERROR ? "[{$error_type}] {$error_message}" : SYL_ERROR_MESSAGE;
        // 顼åɽ
        $this->{$func_name}($error_string, $error_trace, $error_View_type[1]);
        // 
        $this->logging();
    }

    /**
     * ǥեȥ顼
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     * @param string ӥ塼
     */
    function displayErrorDefault($error_string, $error_trace, $view_type)
    {
        echo $error_string;
        if ($error_trace) {
            echo "<br><br>";
            echo $error_trace;
        }
    }

    /**
     * ƥץ졼ȥ顼
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     * @param string ӥ塼
     */
    function displayErrorTemplate($error_string, $error_trace, $view_type)
    {
        // ǡ饹
        include_once SYL_INCLUDE_DIR . '/framework/SyL_DataManager.php';
        $dm =& new SyL_DataManager($this->controller);
        $dm->setTemplateType($view_type);
        $dm->setTemplateFile(SYL_ERROR_FORWARD_FILE);

        // ӥ塼饹
        include_once SYL_INCLUDE_DIR . '/framework/SyL_View.php';
        $view =& SyL_View::getObject($dm);
        $view->setParameter('error_message', $error_string);
        $view->setParameter('error_trace',   $error_trace);
        $view->render();

        // ̱饹
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Response.php';
        $res =& SyL_Response::getInstance();
        $res->display($view);
    }

    /**
     * 顼ڡ˥쥯
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     * @param string ӥ塼
     */
    function displayErrorRedirect($error_string, $error_trace, $view_type)
    {
        // ̱饹
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Response.php';
        SyL_Response::redirect(SYL_ERROR_FORWARD_FILE);
    }

    /**
     * 顼ȥ졼
     *
     * @access public
     * @return string 顼ȥ졼
     */
    function getTraceHtml()
    {
        $error_trace = $this->getTrace();
        $i = count($error_trace);
        $error_trace_result = '';
        if ($i > 0) {
            // 顼ȥ졼ɽκ
            $error_trace_result .= '<table border="1" cellspacing="0" cellpadding="3" bgcolor="#FFFFFF">' . $this->eof;
            $error_trace_result .= '<tr>' . $this->eof;
            $error_trace_result .= '<td colspan="4">Debug Trace</td>' . $this->eof;
            $error_trace_result .= '</tr>' . $this->eof;
            $error_trace_result .= '<tr>'  . $this->eof;
            $error_trace_result .= '<td bgcolor="#CCCCCC">#</td>';
            $error_trace_result .= '<td bgcolor="#CCCCCC">file</td>';
            $error_trace_result .= '<td bgcolor="#CCCCCC">line</td>';
            $error_trace_result .= '<td bgcolor="#CCCCCC">function or method</td>' . $this->eof;
            $error_trace_result .= '</tr>' . $this->eof;
            foreach ($error_trace as $value) {
                if (($value['function'] == '') || ($value['function'] == 'unknown')) {
                    $value['function'] = '&nbsp;';
                }
                if ($value['file'] == '') {
                    $value['file'] = '-';
                }
                if ($value['line'] == '') {
                    $value['line'] = '-';
                }
                $error_trace_result .= '<tr>' . $this->eof;
                $error_trace_result .= '<td>' . $i-- . '</td>';
                $error_trace_result .= '<td>' . $value['file'] . '</td>';
                $error_trace_result .= '<td align="right">' . $value['line'] . '</td>';
                $error_trace_result .= '<td>' . $value['function'] . '</td>' . $this->eof;
                $error_trace_result .= '</tr>' . $this->eof;
            }
            $error_trace_result .= '</table>' . $this->eof;
        }

        return $error_trace_result;
    }
}

?>
