<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataManager.php,v 1.2 2006/12/25 17:30:18 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݡͥȥ᥽åɥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_ComponentMethod.php';

/**
 * ե졼ǡ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataManager.php,v 1.2 2006/12/25 17:30:18 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataManager
{
    /**
     * ƥץ졼ȥ
     * 
     * @access private
     * @var string
     */
    var $template_type = '';
    /**
     * ƥץ졼ȥե
     * 
     * @access private
     * @var string
     */
    var $template_file = '';
    /**
     * ޥӥ塼ե
     * 
     * @access private
     * @var string
     */
    var $customized_view_file = '';
    /**
     * ޥӥ塼饹̾
     * 
     * @access private
     * @var string
     */
    var $customized_view_class = '';
    /**
     * 󥪥֥
     * 
     * @access private
     * @var object
     */
    var $action = null;
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * 롼֥
     * 
     * @access private
     * @var object
     */
    var $router = null;
    /**
     * ݡͥȥ᥽åɥ֥
     * 
     * @access private
     * @var object
     */
    var $cm = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ饪֥
     */
    function SyL_DataManager(&$controller)
    {
        $this->cm =& new SyL_ComponentMethod($controller);
        $this->controller =& $controller;
    }

    /**
     * ܾ󥪥֥Ȥ򥻥å
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function setRouter(&$router)
    {
        $this->router =& $router;
        // ǥХå - ξ
        SyL_Loggers::debug("[DataManager] action info - name: " . $this->getActionName() . " dir: " . $this->getActionDir() . " file: " . $this->getActionFile() . " class: " . $this->getClassName());
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getActionName()
    {
        return is_object($this->router) ? $this->router->getActionName() : null;
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ
     */
    function getActionDir()
    {
        return $this->controller->getActionDir();
    }

    /**
     * ե
     *
     * @access public
     * @return string ե
     */
    function getActionFile()
    {
        return is_object($this->router) ? $this->router->getActionFile() : null;
    }

    /**
     * 饹̾
     *
     * @access public
     * @return string 饹̾
     */
    function getClassName()
    {
        return is_object($this->router) ? $this->router->getClassName() : null;
    }

    /**
     * PATH_INFO
     *
     * @access public
     * @return array PATH_INFO
     */
    function getPathInfoArray()
    {
        return is_object($this->router) ? $this->router->getPathInfoArray() : null;
    }

    /**
     * ƥץ졼ȥפ򥻥åȥ
     * 
     * @access public
     * @param string ƥץ졼
     */
    function setTemplateType($template_type)
    {
        $this->template_type = $template_type;
    }

    /**
     * ƥץ졼ȥפ
     * 
     * @access public
     * @return string ƥץ졼ȥ
     */
    function getTemplateType()
    {
        return $this->template_type;
    }

    /**
     * ƥץ졼ȥե򥻥å
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->convertPath($this->controller->getTemplateDir(), true);
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        $template_dir  = $this->getTemplateDir();
        $template_file = $this->convertPath($this->template_file, false);
        $real_path     = realpath($template_dir . $template_file);
        $reg           = '/^' . preg_quote($template_dir, '/') . '/';

        // ǥХå - ƥץ졼Ȥξ
        SyL_Loggers::debug("[DataManager] template info  dir: {$template_dir} file: {$template_file}");

        // ե¸ߥå
        if (!$real_path || !preg_match($reg, $real_path)) {
            SyL_Response::redirect404();
        }
        return $template_file;
    }

    /**
     * ޥӥ塼å
     * 
     * @access public
     * @param string ޥӥ塼ե
     * @param string ޥӥ塼饹
     */
    function setCustomizedView($customized_view_file, $customized_view_class)
    {
        $this->customized_view_file  = $customized_view_file;
        $this->customized_view_class = $customized_view_class;
    }

    /**
     * ޥӥ塼ե
     * 
     * @access public
     * @return string ޥӥ塼ե
     */
    function getCustomizedViewFile()
    {
        return $this->convertPath($this->customized_view_file, false);
    }

    /**
     * ޥӥ塼饹
     * 
     * @access public
     * @return string ޥӥ塼饹
     */
    function getCustomizedViewClass()
    {
        return $this->customized_view_class;
    }

    /**
     * ѥ
     * 
     * @access public
     * @param string ѥ
     * @return string ѥ
     */
    function convertPath($path, $is_dir_path=false)
    {
        if ($is_dir_path && !preg_match('/(\\\\|\/)$/', $path)) {
            $path = $path . '/';
        } else if (!$is_dir_path && preg_match('/^(\\\\|\/)/', $path)) {
            $path = substr($path, 1);
        }
        return $path;
    }

    /**
     * ե륿ͤ
     * 
     * @access public
     * @param string ե륿̾
     * @return mixed ե륿
     */
    function triggerFilter($name)
    {
        return $this->cm->triggerFilter($name);
    }

    /**
     * ץꥱ󥳥ݡͥȤͤ
     * 
     * @access public
     * @param string ץꥱ󥳥ݡͥ̾
     * @return mixed ץꥱ󥳥ݡͥȤ
     */
    function triggerApp($name)
    {
        return $this->cm->triggerApp($name);
    }

    /**
     * ¹Ƚ򥻥å
     * 
     * @access public
     * @param bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function setExecuteAction($is_execute_action)
    {
        $this->controller->setExecuteAction($is_execute_action);
    }

    /**
     * ݡͥȥ֥Ȥ򥻥å
     * 
     * @access public
     * @param string ݡͥ̾
     * @return object ݡͥ
     */
    function &getComponent($name)
    {
        return $this->controller->container->getComponent($name);
    }

    /**
     * 󥪥֥Ȥ򥻥å
     * 
     * @access public
     */
    function setAction()
    {
        if ($this->controller->container->isComponent(SYL_ACTION_KEY)) {
            $this->action =& $this->getComponent(SYL_ACTION_KEY);
            // ץꥱ󥳥ݥͥȺ
            $this->cm->deleteAppComponent();
        }
    }

    /**
     * 󥪥֥Ȥμ
     * 
     * @access public
     * @return object 󥪥֥
     */
    function &getAction()
    {
        return $this->action;
    }
}

?>
