<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DefinesReader.php,v 1.8 2006/12/25 17:30:18 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Config.php';
/**
 * å奯饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_Cache.php';

/**
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DefinesReader.php,v 1.8 2006/12/25 17:30:18 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DefinesReader
{
    /**
     * 󥹥ȥ饯
     *
     * @static
     * @access public
     * @param object ȥ饪֥
     * @param string ե̾
     */
    function readConfig($defines_file_name)
    {
        // ץꥱͤɤ߹
        $config_file1 = SYL_APP_DIR . "/{$defines_file_name}";
        // Хͤɤ߹
        $config_file2 = SYL_WEBAPP_CONFIG_DIR . "/{$defines_file_name}";

        $config = array();
        if (SYL_WEBAPP_CACHE_DIR) {
            // åѤ
            $cache =& SyL_Cache::getObject($config_file1, 'fileupdate');
            $cache->setCacheDir(SYL_WEBAPP_CACHE_DIR);
            $config = $cache->read(array($config_file1, $config_file2));
            if (!$config) {
                $config = array();
                $config += SyL_DefinesReader::readConfigFile($config_file1);
                $config += SyL_DefinesReader::readConfigFile($config_file2);
                $cache->write($config);
            }
        } else {
            // åѤʤ
            $config += SyL_DefinesReader::readConfigFile($config_file1);
            $config += SyL_DefinesReader::readConfigFile($config_file2);
        }

        // ɤ߹
        SyL_DefinesReader::readDefine($config);
    }

    /**
     * ɤ߹
     *
     * @static
     * @access public
     * @param string ե̾
     * @param object ȥ饪֥
     */
    function readConfigFile($config_file)
    {
        if (is_file($config_file)) {
            $controller = null; // ߡ
            $config =& SyL_Config::getObject('defines', $config_file, $controller);
            $config->parseXML();
            return $config->getConfig();
        } else {
            return array();
        }
    }

    /**
     * ɤ߹
     *
     * @static
     * @access public
     * @param string ե̾
     * @param object ȥ饪֥
     */
    function readDefine($config)
    {
        foreach ($config as $key => $value) {
            $value = preg_replace_callback('/(.*)\{([^\}]+)\}(.*)/', array('SyL_DefinesReader', 'replaceConstant'), $value);
            define($key, $value);
        }
    }

    /**
     * ֤Хå᥽å
     *
     * @static
     * @access public
     * @param array ޥå
     @ return mixed ޥå
     */
    function replaceConstant($matches)
    {
        return defined($matches[2]) ? ($matches[1] . constant($matches[2]) . $matches[3]) : $matches[0];
    }
}

?>
