<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validators.php,v 1.7 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڸ̥롼ץ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validators.php,v 1.7 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Validators extends SyL_Validation
{
    /**
     * ̸ڥ饹ޤȤ᤿
     *
     * @access private
     * @var array
     */
    var $validators = array();

    /**
     * ̸ڥ֥Ȥɲä
     *
     * @access public
     * @param object ̸ڥ֥
     */
    function add(&$validator)
    {
        $this->validators[] =& $validator;
    }

    /**
     * ɬܥå¸Ƚ
     *
     * @access public
     * @return bool true: ɬܥåꡢfalse: ɬܥå̵
     */
    function isRequire()
    {
        foreach (array_keys($this->validators) as $key) {
            if ($this->validators[$key]->isRequire()) {
                return true;
            }
        }
        return false;
    }

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function execute($value)
    {
        foreach (array_keys($this->validators) as $key) {
            if (!$this->validators[$key]->execute($value)) {
                $this->error_message = $this->validators[$key]->getErrorMessage();
                return false;
            }
        }
        return true;
    }

    /**
     * JavaScriptå
     *
     * @access public
     * @param string եHTML̾
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScript($display_name, $parts)
    {
        $js = '';
        foreach (array_keys($this->validators) as $key) {
            $js .= $this->validators[$key]->getJavaScript($display_name, $parts);
        }
        return $js;
    }
}

?>
