<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.9 2007/01/03 11:17:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݒt@Cǂݍ݁A萔NX
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.9 2007/01/03 11:17:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigDefines extends SyL_Config
{
    /**
     * RXgN^
     *
     * @access public
     * @param string XMLt@C
     */
    function SyL_ConfigDefines($file_name)
    {
        // eNX̃RXgN^
        parent::SyL_Config($file_name);
    }

    /**
     * XMLt@C̉͏
     *
     * @access public
     */
    function parseXML()
    {
        if (SYL_WEBAPP_CACHE_DIR) {
            // LbVgp
            $key = implode('', $this->file_names);
            $cache =& SyL_Cache::getObject($key, 'fileupdate');
            $cache->setCacheDir(SYL_WEBAPP_CACHE_DIR . '/defines');
            $this->config = $cache->read($this->file_names);
            if (!$this->config) {
                parent::parseXML();
                $cache->write($this->config);
            }
        } else {
            // LbVgpȂ
            parent::parseXML();
        }
    }

    /**
     * XMLf[^e擾nh\bh
     * I[o[Ch
     *
     * @access public
     * @param string XML͒̃pX
     * @param string XML̃^Ȏl
     * @param string XML̃^O̒l
     */
    function getElement($current_path, $attribute, $text)
    {
        if ($current_path == '/define/param') {
            $this->config[$attribute['name']] = $text;
        }
    }

}

?>
