<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailDefault.php,v 1.8 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ᡼ؿ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailDefault.php,v 1.8 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailDefault extends SyL_Mail
{
    /**
     * 󥹥ȥ饯
     *
     * @access private
     */
    function SyL_MailDefault()
    {
        parent::SyL_Mail();
    }

    /**
     * ᡼
     *
     * @access public
     * @param array ᡼°
     * @param bool ե饰
     */
    function init($attributes=array())
    {
        $attributes = array_change_key_case($attributes, CASE_LOWER);
        parent::init($attributes);
    }

    /**
     * ᡼¹
     *
     * @access public
     * @return OK: null, NG: SyL_Error_Parameter֥
     */
    function send()
    {
        // Fromɬ
        if ($this->headers['MAIL_FROM'] == '') {
            $this->error_message = "[SyL error] From Address not found";
            return false;
        }
        // Toɬ
        if (count($this->headers['To']) == 0) {
            $this->error_message = "[SyL error] To Address not found";
            return false;
        }

        // ꥿ѥΥå
        if ($this->headers['MAIL_FROM'] != '') {
            $additional_parameters = ' -f' . $this->headers['MAIL_FROM'];
        } else {
            $additional_parameters = null;
        }

        // ᡼¹
        if (!mail(null, $this->headers['Subject'], null, $this->getHeaderMessage($this->body), $additional_parameters)) {
            $this->error_message = "[SyL error] mail function execute error";
            return false;
        }

        // 
        $this->init();

        return true;
    }
}

?>
