<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XMLParser.php,v 1.9 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!defined('SYL_XML_ENCODE')) {
    define('SYL_XML_ENCODE', 'UTF-8');
}

/**
 *  XMLѡ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XMLParser.php,v 1.9 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XMLParser
{
    /**
     * եѥURLǤOK
     *
     * @access private
     * @var string
     */
    var $file_name = '';
    /**
     * XMLʸ
     *
     * @access private
     * @var string
     */
    var $xml_encode = SYL_XML_ENCODE;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     */
    function SyL_XMLParser($file_name)
    {
        $this->setFile($file_name);
    }

    /**
     * XMLե򥻥å
     *
     * @access public
     * @param int ȥ꡼
     */
    function setFile($file_name)
    {
        if (!file_exists($file_name)) {
            trigger_error("[SyL error] Xml file not found ({$file_name})", E_USER_ERROR);
        }
        $this->file_name = $file_name;
    }

    /**
     * XMLեβϽ
     *
     * @access private
     */
    function parseXML()
    {
        // XMLѡ ʸUTF-8
        $parser = xml_parser_create($this->xml_encode);
        // ʸѴԤʤ
        xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
        // ϥɥ᥽åɤ򥯥饹᥽åɤ
        xml_set_object($parser, &$this);
        // start  end ǤΥϥɥꤹ
        xml_set_element_handler( $parser,
          array(&$this, 'startElement'),
          array(&$this, 'endElement'  )
        );
        // ʸǡϥɥꤹ
        xml_set_character_data_handler($parser, array(&$this, 'characters'));

        // XMLե륪ץ
        if (($fp = @fopen($this->file_name, 'r')) == false) {
            trigger_error("[SyL error] Can't open xml file({$this->file_name})", E_USER_ERROR);
        } else {
            $file_size = filesize($this->file_name);
            // ɤ߹ߤȲ
            while ($data = fread($fp, $file_size)) {
                // XMLѡ
                if (!xml_parse($parser, $data, feof($fp))){
                    // ѡ顼
                    trigger_error(
                      sprintf("[SyL error] XML parse error: %s at %s (%d)",
                        xml_error_string(xml_get_error_code($parser)),
                        $this->file_name,
                        xml_get_current_line_number($parser)
                      ),
                      E_USER_ERROR
                    );
                }
            }
            // XMLե륯
            fclose($fp);
        }
        // XMLѡγ 
        xml_parser_free($parser);
    }

    /**
     * ȳϤμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     * @param array Ȥ°
     */
    function startElement(&$parser, $name, $attr) {}

    /**
     * Ƚλμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     */
    function endElement(&$parser, $name) {}

    /**
     * 饯Ȥμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ʸ
     */
    function characters(&$parser, $text) {}
}

?>
