<?php
/**
 * ץꥱǥ쥯ȥݡͥȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: C_CreateApplication.php,v 1.5 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class C_CreateApplication
{
    /**
     * ץꥱǥ쥯ȥ
     *
     * @access public
     * @param string ץȥǥ쥯ȥ
     * @param string ץꥱ̾
     */
    function trigger($project_dir, $app_name)
    {
        $app_dir = "{$project_dir}app/{$app_name}/";
        if (!is_dir($app_dir)) {
            echo "  creating directory {$app_dir}\n"; ob_flush();
            if (!mkdir($app_dir, 0755)) {
                trigger_error("[SyL error] Application directory can't create ({$app_dir})", E_USER_ERROR);
                exit;
            }
        }

        $dirs = array(
          'actions'   => 0755,
          'templates' => 0755
        );

        foreach ($dirs as $dir => $mode) {
            if (!is_dir($app_dir . $dir)) {
                echo "  creating directory {$app_dir}{$dir}\n"; ob_flush();
                mkdir("{$app_dir}{$dir}", $mode);
            }
        }

        echo "  copying file {$app_dir}actions.xml\n"; ob_flush();
        if (file_exists("{$project_dir}var/skel-templates/actions.xml")) {
            copy("{$project_dir}var/skel-templates/actions.xml", "{$app_dir}actions.xml");
        } else {
            copy(SYL_WEBAPP_DIR . '/var/skel-templates/actions.xml', "{$app_dir}actions.xml");
        }

        echo "  copying file {$app_dir}defines.xml\n"; ob_flush();
        if (file_exists("{$project_dir}var/skel-templates/defines_app.xml")) {
            copy("{$project_dir}var/skel-templates/defines_app.xml", "{$app_dir}defines.xml");
        } else {
            copy(SYL_WEBAPP_DIR . '/var/skel-templates/defines_app.xml', "{$app_dir}defines.xml");
        }

        echo "  copying file {$app_dir}filters.xml\n"; ob_flush();
        if (file_exists("{$project_dir}var/skel-templates/filters.xml")) {
            copy("{$project_dir}var/skel-templates/filters.xml", "{$app_dir}filters.xml");
        } else {
            copy(SYL_WEBAPP_DIR . '/var/skel-templates/filters.xml', "{$app_dir}filters.xml");
        }

        echo "  copying file {$app_dir}layouts.xml\n"; ob_flush();
        if (file_exists("{$project_dir}var/skel-templates/layouts.xml")) {
            copy("{$project_dir}var/skel-templates/layouts.xml", "{$app_dir}layouts.xml");
        } else {
            copy(SYL_WEBAPP_DIR . '/var/skel-templates/layouts.xml', "{$app_dir}layouts.xml");
        }
    }
}

?>
