<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Pager.php,v 1.3 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  ڡѥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Pager.php,v 1.3 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Pager
{
    /**
     * 
     * 
     * @access private
     * @var int
     */
    var $sum = 0;
    /**
     * 1ڡɽ
     * 
     * @access private
     * @var int
     */
    var $num = 0;
    /**
     * ߥڡ
     * 
     * @access private
     * @var int
     */
    var $current_page = 1;
    /**
     * ߻ȤƤڡ
     * 
     * @access private
     * @var int
     */
    var $page = 1;

    /**
     * ڡURL
     * 
     * @access private
     * @var string
     */
    var $url = '';

    /**
     * ڡ衢ѥ᡼̾ʥڡѥ᡼
     * 
     * @access private
     * @var string
     */
    var $page_parameter_name = 'page';
    /**
     * ڡ衢ѥ᡼̾ʥڡʳ
     * 
     * @access private
     * @var string
     */
    var $etc_parameters = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Pager()
    {
        $this->url = $_SERVER['PHP_SELF'];
    }

    /**
     * 1ڡη򥻥å
     *
     * @access public
     * @param int 1ڡη
     */
    function setCount($num)
    {
        if (!is_numeric($num) || ($num < 0)) {
            $num = 0;
        }
        $this->num = $num;
    }

    /**
     * 1ڡΥ쥳ɿ
     *
     * @access public
     * @return int 1ڡΥ쥳ɿ
     */
    function getCount()
    {
        return $this->num;
    }

    /**
     * 򥻥å
     *
     * @access public
     * @param int 
     */
    function setCountAll($sum)
    {
        if (!is_numeric($sum) || ($sum < 0)) {
            $sum = 0;
        }
        $this->sum = $sum;
    }

    /**
     * ǡ
     *
     * @access public
     *
     * @return int ǡ
     */
    function getCountAll()
    {
        return $this->sum;
    }

    /**
     * ߤΥڡ򥻥å
     *
     * @access public
     * @param int ߤΥڡ
     */
    function setPage($current_page)
    {
        if (!is_numeric( $current_page ) || ($current_page < 1)) {
            $current_page = 1;
        }
        $this->current_page = $current_page;
    }

    /**
     * ߥڡ
     *
     * @access public
     * @return int ߥڡ
     */
    function getPage()
    {
        // 쥳ɿ0ΤȤϥڡ0
        if ($this->sum <= 0) {
            return 0;
        // ڡʾΥڡꤵ줿1ڡܤ
        } else if ($this->current_page > $this->getTotalPage()) {
            return 1;
        } else {
            return $this->current_page;
        }
    }

    /**
     * URL򥻥å
     *
     * @access public
     * @param string URL
     */
    function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * ڡѥ᡼̾򥻥å
     *
     * @access public
     * @param string ڡѥ᡼̾
     */
    function setPageParameterName($page_parameter_name)
    {
        $this->page_parameter_name = $page_parameter_name;
    }

    /**
     * ѥ᡼򥻥å
     * URL󥳡ɺѤߤȤ
     *
     * @access public
     * @param string URL
     */
    function setEtcParameter($etc_parameters)
    {
        $this->etc_parameters = $this->getAmp( $etc_parameters );
    }

    /**
     * ǡκǽΥ쥳ɤ
     * ǽΥ쥳ɤ0Ȥ롣
     *
     * @access public
     * @return int ǡκǽΥ쥳
     */
    function getStartRecord()
    {
        $offset = $this->getCount() * ($this->getPage() - 1);
        return (($offset < 0) ? 0 : $offset);
    }

    /**
     * ڡ
     *
     * @access public
     * @return int ڡ
     */
    function getTotalPage()
    {
        // ץ쥳ɿޤ1ڡ0ʲʤ0ڡ
        return ((($this->sum <= 0) || ($this->num <= 0)) ? 0 : ceil( $this->sum / $this->num ));
    }

    /**
     * ڡ󥯼
     *
     * @access public
     * @param string 󥯥åʥ󥯤
     * @param string 󥯥åʥ̵
     * @return string ڡ󥯥
     */
    function getNextLink($active_link_message, $noactive_link_message='')
    {
        // 쥳ɿ0ڡʤޤϸMAXڡܾ
        if (($this->sum <= 0) || ($this->getTotalPage() == 1) || ($this->current_page >= $this->getTotalPage())) {
            return (($noactive_link_message == '') ? $active_link_message : $noactive_link_message);
        // ڡʾΥڡꤵ줿1ڡܥ󥯤
        } else if ($this->current_page > $this->getTotalPage()) {
            return '<a href="' . $this->url . '?' . $this->page_parameter_name . '=2' . $this->etc_parameters . '">' . $active_link_message . '</a>';
        } else {
            return '<a href="' . $this->url . '?' . $this->page_parameter_name . '=' . ($this->current_page + 1) . $this->etc_parameters . '">' . $active_link_message . '</a>';
        }
    }

    /**
     * ڡ󥯼
     *
     * @access public
     * @param string 󥯥åʥ󥯤
     * @param string 󥯥åʥ̵
     * @return string ڡ󥯥
     */
    function getPrevLink($active_link_message, $noactive_link_message='')
    {
        // 쥳ɿ0ڡʤޤϸ1ڡܾ
        if (($this->sum <= 0) || ($this->getTotalPage() == 1) || ($this->current_page == 1)) {
            return (($noactive_link_message == '') ? $active_link_message : $noactive_link_message);
        // ڡʾΥڡꤵ줿1ڡܥ󥯤
        } else if ($this->current_page > $this->getTotalPage()) {
            return (($noactive_link_message == '') ? $active_link_message : $noactive_link_message);
        } else {
            return '<a href="' . $this->url . '?' . $this->page_parameter_name . '=' . ($this->current_page - 1) . $this->etc_parameters . '">' . $active_link_message . '</a>';
        }
    }

    /**
     * ڡ󥯼
     *
     * @access public
     * @param string 󥯥åʥ󥯤
     * @return string ڡ󥯥
     */
    function getLinkAll()
    {
        static $page = null;
        if ($page == null) {
            $page = 1;
        }
        // MAXڡĶ齪λ
        if ($page > $this->getTotalPage()) {
            $page = null;
            return false;
        }
        if ($this->current_page != $page) {
            $link_message = '<a href="' . $this->url . '?' . $this->page_parameter_name . '=' . $page . $this->etc_parameters . '">' . $page . '</a>';
        } else {
            $link_message = $page;
        }

        $page++;
        return $link_message;
    }

    /**
     * ڡSelectΥץ
     *
     * @access public
     * @return string ڡSelectΥץ
     */
    function getSelectOption()
    {
        // ڡ
        $max_page = $this->getTotalPage();

        $options = '';
        for ($i=1; $i<=$max_page; $i++) {
            $active = ($i == $this->current_page) ? 'selected' : '';
            $options .= '<option value="' . $this->url . '?' . $this->page_parameter_name . '=' . $i . $this->etc_parameters . '" ' . $active . '>&nbsp;' . $i . '/' . $max_page . "\r\n";
        }

        return $options;
    }

    /**
     * URLѥ᡼Фơ&פɲä
     *
     * @access public
     * @return string &ɲøʸ
     */
    function getAmp($str)
    {
        if (($str != '') && (substr($str, 0, 1) != '&')) {
            $str = '&' . $str;
        }
        return $str;
    }
}

?>
