<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XMLParserOperation.php,v 1.10 2007/01/15 15:55:12 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLѡ饹
 */
require_once 'SyL_XMLParser.php';

if (!defined('SYL_SCRIPT_ENCODE')) {
    define('SYL_SCRIPT_ENCODE', 'EUC-JP');
}

/**
 *  XMLǼ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XMLParserOperation.php,v 1.10 2007/01/15 15:55:12 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XMLParserOperation extends SyL_XMLParser
{
    /**
     * ɽʸ
     *
     * @access private
     * @var string
     */
    var $script_encde = SYL_SCRIPT_ENCODE;
    /**
     * XMLΥγ
     *
     * @access private
     * @var int
     */
    var $depth = 0;
    /**
     * ͭȳ
     *
     * @access private
     * @var int
     */
    var $depth_row = 0;
    /**
     * XMLΥѥ
     *
     * @access private
     * @var array
     */
    var $current_path = array();
    /**
     * XMLΥ°
     *
     * @access private
     * @var array
     */
    var $attribute = array();
    /**
     * XMLΥ
     *
     * @access private
     * @var string
     */
    var $text = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     */
    function SyL_XMLParserOperation($file_name)
    {
        // ƥ饹Υ󥹥ȥ饯
        parent::SyL_XMLParser($file_name);
    }

    /**
     * XMLեΥ󥳡ɤ򥻥å
     *
     * @access public
     * @param string 󥳡̾
     */
    function setXmlEncode($xml_encode)
    {
        $this->xml_encode = $xml_encode;
    }

    /**
     * ץȤΥ󥳡ɤ򥻥å
     *
     * @access public
     * @param string 󥳡̾
     */
    function setScriptEncode($script_encde)
    {
        $this->script_encde = $script_encde;
    }

    /**
     * ȳϤμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     * @param array Ȥ°
     */
    function startElement(&$parser, $name, $attr)
    {
        // ʸѴ
        $name = mb_convert_encoding( $name, $this->script_encde, $this->xml_encode );
        // °ͼ
        $attribute = array();
        foreach ($attr as $key => $value) {
            $key   = mb_convert_encoding( $key,   $this->script_encde, $this->xml_encode );
            $value = mb_convert_encoding( $value, $this->script_encde, $this->xml_encode );
            $attribute[$key] = $value;
        }

//echo "PATH - " . $name . " - " . $this->depth . " - " .$this->depth_row . "<br>";

        // ¸ѥ1ɲ
        $this->current_path[$this->depth] = $name;
        // ¸°1ɲ
        $this->attribute[$this->depth] = $attribute;
        // 1ɲ
        $this->depth++;
    }

    /**
     * Ƚλμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     */
    function endElement(&$parser, $name)
    {
        if ($this->text != '') {
            $this->getElement( $this->getCurrentPath(), $this->attribute[count($this->attribute)-1], $this->text );
        }
        // ޤǤγؤǼ
        $cnt = count($this->attribute);
        $this->getDepthElements( $cnt );

//echo "EE - " . $this->depth . " - " . $this->depth_row . " - " . $this->getCurrentPath() . "<br>";
        // 1غ
        $this->depth--;
        $this->depth_row--;
        // ¸ѥ1غ
        unset($this->current_path[$this->depth]);
        // ¸°1غ
        unset($this->attribute[$this->depth]);
        // Text
        $this->text = '';
    }

    /**
     * 饯Ȥμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ʸ
     */
    function characters(&$parser, $text)
    {
        if (trim($text) !== '') {
            // ޤǤγؤǲذʳǼ
            $cnt = count($this->attribute) -1;
            $this->getDepthElements( $cnt );
            $this->depth_row++;
            // ʸѴ
            $this->text .= mb_convert_encoding( $text, $this->script_encde, $this->xml_encode );
        }
    }

    /**
     * Ǽ
     *
     * @access abstract
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text) {}

    /**
     * ޤǤγؤǼ
     *
     * @access private
     * @param int ؿ
     */
    function getDepthElements($cnt)
    {
        $tmp_path = '';
        for ($i=0; $i<$cnt; $i++) {
            $tmp_path .= '/' . $this->current_path[$i];
            if ($this->depth_row <= $i) {
                $this->getElement( $tmp_path, $this->attribute[$i], null );
                $this->depth_row++;
            }
        }
    }

    /**
     * XMLΥѥ
     *
     * @access public
     * @return string XMLΥѥ
     */
    function getCurrentPath()
    {
        return '/' . implode('/', $this->current_path);
    }
}


?>
