<?php
/**
 * ȥե饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: controller.php,v 1.3 2006/12/23 11:14:31 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Controller
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Controller()
    {
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     * @param object ݡͥȥ᥽åɥ֥
     */
    function execute(&$cmd, &$cm)
    {
        $project_dir     = $cmd->getArg('-d');
        $app_name        = $cmd->getArg('-w');
        $controller_file = $cmd->getArg('-c');

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cnt = count($project_dir);
        if ($cnt == 0) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Project directory (-d) only 1", E_USER_ERROR);
            exit;
        }

        $project_dir = preg_match('/(\\\\|\/)$/', $project_dir[0]) ? $project_dir[0] : $project_dir[0] . '/';

        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $cnt = count($app_name);
        if ($cnt == 0) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Application name (-w) only 1", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name[0])) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        } else {
            $app_name = $app_name[0];
        }

        $app_dir = $project_dir . 'app/' . $app_name . '/';

        if (!file_exists($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ȥեå
        // -------------------------------------------------
        $cnt = count($controller_file);
        if ($cnt == 0) {
            trigger_error("[SyL error] Controller file (-c) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Controller file (-c) only 1", E_USER_ERROR);
            exit;
        } else {
            $controller_file = $controller_file[0];
        }

        if (!file_exists($controller_file)) {
            trigger_error("[SyL error] Already controller file exists ({$controller_file})", E_USER_ERROR);
            exit;
        }


        // -------------------------------------------------
        // ȥե
        // -------------------------------------------------
        $cm->triggerApp('c_controller', $project_dir, $app_name, $controller_file);
    }

}

?>
