<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestParameterSession.php,v 1.4 2007/01/28 07:13:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥ᡼ݻ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_RequestParameter.php';

/**
 * åݻ饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestParameterSession.php,v 1.4 2007/01/28 07:13:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RequestParameterSession extends SyL_RequestParameter
{
    /**
     * å̾
     *
     * @access private
     * @var string
     */
    var $name = SYL_SESSION_NAME;
    /**
     * åѥ
     *
     * @access private
     * @var string
     */
    var $path = SYL_SESSION_PATH;
    /**
     * ɥᥤ
     *
     * @access private
     * @var string
     */
    var $domain = SYL_SESSION_DOMAIN;
    /**
     * å
     *
     * @access private
     * @var string
     */
    var $cache = SYL_SESSION_CACHE;
    /**
     * 奢
     *
     * @access private
     * @var bool
     */
    var $secure = SYL_SESSION_SECURE;

    /**
     * å󳫻ϥե饰
     *
     * @access private
     * @var bool
     */
    var $start = false;

    /**
     * DBå󥪥֥
     *
     * @access private
     * @var object
     */
    var $session_db = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RequestParameterSession()
    {
        if (!$this->start) {
            // å̾򥻥å
            if ($this->name != '') {
                session_name($this->name);
            }
            // åѹ
            if (SYL_SESSION_CACHE != '') {
                session_cache_limiter($this->cache);
            }
            // åƼѥ᡼
            $session_path   = ($this->path != '')   ? $this->path   : '/';
            $session_domain = ($this->domain != '') ? $this->domain : null;
            $session_secure = ($this->secure) ? true : false;
            session_set_cookie_params(0, $session_path, $session_domain, $session_secure);

            // PHP 4.3.3 ʹ
            //session_regenerate_id();

            if (strtolower(SYL_SESSION_TYPE) == 'db') {
                // DBå
                include_once SYL_INCLUDE_DIR . '/framework/RequestParameter/SyL_SessionDB.php';
                $this->session_db =& new SyL_SessionDB();
            }

            // å󳫻
            $this->startSession();
        }
    }

    /**
     * å򳫻Ϥ
     *
     * @access public
     */
    function startSession()
    {
        if (!$this->start) {
            session_start();
            $this->start = true;
            $this->parameters =& $_SESSION;
        }
    }

    /**
     * å󤬳ϤƤ뤫Ƚ
     *
     * @access public
     * @return true: ϤƤ롢false: ϤƤʤ
     */
    function isSession()
    {
        return $this->start;
    }

    /**
     * ѥ᡼
     * 
     * @access public
     */
    function deleteParameters()
    {
        parent::deleteParameters();
        if (isset($_COOKIE[session_name()])) {
           setcookie(session_name(), '', time()-42000, $this->path);
        }
        session_destroy();
        $this->start = false;
    }

    /**
     * åͤ¸λ
     * 
     * @access public
     * @param array ѥ᡼
     */
    function writeCloseSession($values)
    {
        $this->startSession();
        parent::setParameters($values);
        $this->closeSession();
    }

    /**
     * åλ
     * 
     * @access public
     */
    function closeSession()
    {
        if ($this->start) {
            session_write_close();
            $this->start = false;
            parent::deleteParameters();
        }
    }

    /**
     * åID
     * 
     * @access public
     * @return mixed åID
     */
    function getSid()
    {
        return urlencode(session_id());
    }

    /**
     * ѥ᡼̾եåID
     * 
     * @access public
     * @return string ѥ᡼̾եåID
     */
    function getSidQuery()
    {
        return strip_tags(SID);
    }
}

?>
