/**
 * SyL_Ajaxǥ󥰥饹
 *
 */
var SyL_AjaxLoading = {
  func      : [],
  timer     : [],
  id        : '_syl_iframe',
  timeout   : 500,
  exclusive : [],
  process : function(form, config, parameter)
  {
    var i = SyL_AjaxLoading.func.length;
    if (config && config.exclusive) {
      for (var j in SyL_AjaxLoading.exclusive) {
        if (SyL_AjaxLoading.exclusive[j] == config.exclusive) {
          return false;
        }
      }
      SyL_AjaxLoading.exclusive[i] = config.exclusive;
    } else {
      SyL_AjaxLoading.exclusive[i] = null;
    }

    var id = SyL_AjaxLoading.id + i;
    var div = document.createElement('div');
    div.innerHTML = '<iframe style="display:none" src="about:blank" id="' + id + '" name="' + id + '" onLoad="SyL_AjaxLoading.loaded(\'' + i + '\', \'' + parameter + '\')"></iframe>';
    document.body.appendChild(div);
    form.target = id;

    var start = false;
    if (config) {
      if (typeof(config.loaded) == 'function') {
        var iframe = document.getElementById(id);
        iframe.loaded = config.loaded;
      }
      if (typeof(config.start) == 'function') {
        start = config.start(parameter);
      } else {
        start = true;
      }
      if (start && (typeof(config.loading) == 'function')) {
        SyL_AjaxLoading.func[i] = config.loading;
        SyL_AjaxLoading.loading(i, parameter);
      }
    } else {
      start = true;
    }

    return start;
  },

  loading : function(i, parameter)
  {
    if (typeof(SyL_AjaxLoading.func[i]) != 'function') {
      return;
    }
    SyL_AjaxLoading.func[i](parameter);
    SyL_AjaxLoading.timer[i] = setTimeout("SyL_AjaxLoading.loading(" + i + ", '" + parameter + "')", SyL_AjaxLoading.timeout);
  },

  loaded : function(i, parameter)
  {
    var id = SyL_AjaxLoading.id + i;
    var iframe = document.getElementById(id);
    var doc;
    if (iframe.contentDocument) {
      doc = iframe.contentDocument;
    } else if (iframe.contentWindow) {
      doc = iframe.contentWindow.document;
    } else {
      doc = window.frames[id].document;
    }
    if (doc.location.href == "about:blank") {
        return;
    }

    SyL_AjaxLoading.func[i]      = null;
    SyL_AjaxLoading.exclusive[i] = null;
    if (SyL_AjaxLoading.timer[i]) {
      clearTimeout(SyL_AjaxLoading.timer[i]);
      SyL_AjaxLoading.timer[i] = null;
    }

    if (typeof(iframe.loaded) == 'function') {
      iframe.loaded(doc.body.innerHTML, parameter);
    }
  }
}

/**
 * ץ쥹С饹
 */
function SyL_AjaxProgressBar(id, type, width, height)
{
  this.id     = id;
  this.type   = (type) ? type : 'standard';
  this.width  = (typeof(width) == "number")  ? String(width)  : width;
  this.height = (typeof(height) == "number") ? String(height) : height;
  this.idbar  = '_syl_bar_' + id;
  this.idtd   = '_syl_td_' + id;
  this.percentage = true;
  this.created = false;

  if (!this.width) {
    if (document.getElementById(id).currentStyle) {
      this.width  = document.getElementById(id).currentStyle['width'];
    } else if (getComputedStyle) {
      this.width = getComputedStyle(document.getElementById(id)).getPropertyValue('width');
    } else {
      alert('unabled to get width');
      return;
    }
  }

  this.width = this.width.match(/^[0-9]+/);

  if (!this.height) {
    if (document.getElementById(id).currentStyle) {
      this.height  = document.getElementById(id).currentStyle['height'];
    } else if (getComputedStyle) {
      this.height = getComputedStyle(document.getElementById(id)).getPropertyValue('height');
    } else {
      alert('unabled to get height');
      return;
    }
  }

  this.height = this.height.match(/^[0-9]+/);
}

SyL_AjaxProgressBar.prototype = {

  displayPercentage: function(percentage)
  {
    this.percentage = (percentage) ? true : false;
  },

  create: function(option)
  {
    var width1;
    var width2;

    width2 = (this.percentage) ? 36 : 0;
    width1 = this.width - width2;

    var blank = 4;

    var progress = document.getElementById(this.id);
    progress.innerHTML = '';

    progress.style.width       = this.width + "px";
    progress.style.height      = "auto";
    progress.style.border      = "1px";
    progress.style.borderStyle = "solid";
    progress.style.borderColor = "#999999";
    progress.style.backgroundColor  = "#D6D3CE";

    var table = document.createElement("table");
    /*table.style.width  = "100%";*/
    table.style.margin = "2px";
    table.style.borderCollapse = "collapse";
    progress.appendChild(table);

    var tbody = document.createElement("tbody");
    table.appendChild(tbody);

    var tr = document.createElement("tr");
    tbody.appendChild(tr);

    var td = document.createElement("td");
    td.style.width       = width1 + "px";
    td.style.border      = "1px";
    td.style.borderStyle = "solid";
    td.style.borderColor = "#BBBBBB";
    td.style.backgroundColor  = "#EEEEEE";
    tr.appendChild(td);

    var bar;
    switch (this.type) {
    case 'smooth':
      bar = this.createSmooth(this.height - blank, option);
      break;
    default:
      bar = this.createStandard(this.height - blank, option);
      break;
    }
    td.appendChild(bar);

    if (width2 > 0) {
      var td = document.createElement("td");
      td.setAttribute("id", this.idtd);
      td.style.width         = width2 + "px";
      td.style.margin        = "0px";
      td.style.padding       = "0px";
      td.style.fontSize      = "12px";
      td.style.textAlign     = "center";
      td.style.verticalAlign = "middle";
      td.innerHTML = "0%";
      tr.appendChild(td);
    } else {
      this.idtd = '';
    }

    this.created = true;
  },

  createStandard: function(height, option)
  {
    var table = document.createElement("table");
    table.style.width   = "100%";
    table.style.margin  = "0px";
    table.style.padding = "0px";
    table.style.borderCollapse = "separate";

    var tbody = document.createElement("tbody");
    table.appendChild(tbody);

    var tr = document.createElement("tr");
    tbody.appendChild(tr);

    var separate = (option && (option.separate)) ? option.separate : 10;

    var idbar = '';
    for (var i=1; i<=separate; i++) {
      var tmp = this.idbar + String(i);
      var td = document.createElement("td");
      td.setAttribute("id", tmp);
      td.style.height = height + "px";
      td.style.backgroundColor = "#EEEEEE";
      tr.appendChild(td);
      idbar += (idbar == '') ? tmp : ',' + tmp;
    }
    this.idbar = idbar;

    return table;
  },

  createSmooth: function(height, option)
  {
    var div = document.createElement("div");
    div.setAttribute("id", this.idbar);
    div.style.width           = "0%";
    div.style.height          = height + "px";
    div.style.backgroundColor = "#0B2467";
    return div;
  },

  clear: function()
  {
    if (document.getElementById(this.idtd)) {
      document.getElementById(this.idtd).innerHTML = "0%";
    }
    switch (this.type) {
    case 'smooth':
      bar = this.clearSmooth();
      break;
    default:
      bar = this.clearStandard();
      break;
    }
  },

  clearStandard: function()
  {
    var idss  = this.idbar.split(",");
    var num   = idss.length;
    for (var i=0; i<num; i++) {
      document.getElementById(idss[i]).style.backgroundColor  = "#EEEEEE";
    }
  },

  clearSmooth: function()
  {
    document.getElementById(this.idbar).style.width = "0%";
  },

  start: function(form)
  {
    if (!this.created) {
      this.create();
    }

    var s = SyL_AjaxLoading.process(
      form,
      {
        'start'   : this.startCallback,
        'loading' : this.loadingCallback,
        'loaded'  : this.completeCallback,
        'exclusive' : this.id
      },
      this.type + "\t" + this.id + "\t" + this.idbar + "\t" + this.idtd
    );

    if (s) {
      this.clear();
    }
    return s;
  },

  /* @static */
  startCallback: function(id)
  {
    return true;
  },

  /* @static */
  loadingCallback: function(id)
  {
     var ids = id.split("\t");
     SyL_AjaxRequest.sendAsyncPost(
       ids[1], 
       function(result)
       {
         if (result.progress) {
           if (ids[0] == 'smooth') {
             document.getElementById(ids[2]).style.width = result.progress + "%";
           } else {
             var idss  = ids[2].split(",");
             var num   = idss.length;
             var point = 100 / num;
             for (var i=0; i<num; i++) {
               if (result.progress >= Math.ceil(point * (i+1))) {
                 document.getElementById(idss[i]).style.backgroundColor  = "#0B2467";
               } else {
                 break;
               }
             }
           }
           if (ids[3]) {
             document.getElementById(ids[3]).innerHTML = result.progress + "%";
           }
         }
       },
       null,
       {'finish': '0'}
     );
  },

  /* @static */
  completeCallback: function(body, id)
  {
     var ids = id.split("\t");
     SyL_AjaxRequest.sendAsyncPost(
       ids[1], 
       function(result)
       {
         if (result.progress < 100) {
           alert("Request Timeout ? (" + result.progress + "% end)");
         }
         if (result.progress) {
           if (ids[0] == 'smooth') {
             document.getElementById(ids[2]).style.width = result.progress + "%";
           } else {
             var idss  = ids[2].split(",");
             var num   = idss.length;
             var point = 100 / num;
             for (var i=0; i<num; i++) {
               if (result.progress >= Math.ceil(point * (i+1))) {
                 document.getElementById(idss[i]).style.backgroundColor = "#0B2467";
               } else {
                 break;
               }
             }
           }
           if (ids[3]) {
             document.getElementById(ids[3]).innerHTML = result.progress + "%";
           }
         }
       },
       null,
       {'finish': '1'}
     );
  }

}

