<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.14 2007/02/03 11:44:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Хåե
 */
ob_start();
/**
 * magic_quotes_runtime -> off
 */
set_magic_quotes_runtime(0);
/**
 * PHPƥ२顼¸
 */
if (SYL_ERROR_SYSTEM_LOG && is_writable(dirname(SYL_ERROR_SYSTEM_LOG_FILE))) {
    ini_set('log_errors', SYL_ERROR_SYSTEM_LOG);
    ini_set('error_log', SYL_ERROR_SYSTEM_LOG_FILE);
}

/**
 * եɤ߹९饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_DefinesReader.php';
/**
 * ƥʥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Container.php';

/**
 * ƥ⥳ȥ̾
 */
define('SYL_CONTROLLER_NAME', 'controller');

/**
 * ȥ饯饹
 *
 * Τνή
 * Ƥ
 *   DIƥʤݻ
 *   ήȼܥ٥Ƚ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.14 2007/02/03 11:44:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Controller
{
    /**
     * ǥ쥯ȥ롼
     *
     * @access private
     * @var string
     */
    var $action_dir = '';
    /**
     * ƥץ졼ȥǥ쥯ȥ롼
     *
     * @access private
     * @var string
     */
    var $template_dir = '';
    /**
     * ե̾
     *
     * @access private
     * @var string
     */
    var $defines_file_name = 'defines.xml';
    /**
     * ݡͥե̾
     *
     * @access protected
     * @var string
     */
    var $components_file_name = 'components.xml';
    /**
     * 顼ϥɥ᥽å̾
     * ''ξϥ顼ϥɥꤷʤ
     *
     * @access private
     * @var string
     */
    var $error_handler_method = 'errorStream';
    /**
     * ˴᥽å̾
     * ''ξϽ˴᥽åɤꤷʤ
     *
     * @access private
     * @var string
     */
    var $destory_handler_method = 'finalStream';
    /**
     * 顼
     *
     * @access private
     * @var array
     */
    var $error = array();
    /**
     * ƥʥ֥
     *
     * @access private
     * @var object
     */
    var $container = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param array Ķ
     */
    function SyL_Controller($config)
    {
        // ץꥱ̾
        if (!isset($config['app_name']) || !$config['app_name']) {
            trigger_error("[SyL error] Controller parameter app_name not exists", E_USER_ERROR);
        }

        // ǥХå٥
        define('SYL_DEBUG', (isset($config['debug']) && is_numeric($config['debug'])) ? $config['debug'] : SYL_LOG_NOTICE);
        // WEBץꥱǥ쥯ȥ
        define('SYL_WEBAPP_DIR', (isset($config['webapp_dir']) && $config['webapp_dir']) ? $config['webapp_dir'] : SYL_DIR . '/webapp');
        // å
        define('SYL_WEBAPP_CACHE_DIR', (isset($config['cache_dir']) && $config['cache_dir']) ? SYL_WEBAPP_DIR . $config['cache_dir'] : false);
        // WEBץꥱեǥ쥯ȥ
        define('SYL_WEBAPP_CONFIG_DIR',  SYL_WEBAPP_DIR . '/config');
        // WEBץꥱ饤֥ǥ쥯ȥ
        define('SYL_WEBAPP_LIB_DIR',  SYL_WEBAPP_DIR . '/lib');
        // ץꥱǥ쥯ȥ
        define('SYL_APP_DIR', SYL_WEBAPP_DIR . '/app/' . $config['app_name']);

        // ɤ߹
        SyL_DefinesReader::readConfig($this->defines_file_name);

        // ǥ쥯ȥ
        $this->action_dir = SYL_APP_DIR . '/actions';
        // ƥץ졼ȥǥ쥯ȥ
        $this->template_dir = SYL_APP_DIR . '/templates';

        // ƥ
        $this->container =& SyL_Container::getContainer();
        $this->container->setComponent(SYL_CONTROLLER_NAME, $this);

        // shutdownϥɥ
        if ($this->destory_handler_method != '') {
            register_shutdown_function(array(&$this, $this->destory_handler_method));
        }
        // 顼ϥɥ
        if ($this->error_handler_method != '') {
            set_error_handler(array(&$this, $this->error_handler_method));
        }
    }

    /**
     * ȥ
     *
     * ¹ԴĶˤꡢWEB or CmdΥȥȽꤷƼ
     *
     * @access public
     * @param array Ķ
     */
    function &getController($config=array())
    {
        static $singleton;
        if (!is_object($singleton)) {
            if (isset($config['type']) && $config['type']) {
                define('SYL_ENV_TYPE', $config['type']);
            } else {
                if ((PHP_SAPI == 'cli') || ((PHP_SAPI == 'cgi') && !isset($_SERVER['REQUEST_METHOD']))) {
                    define('SYL_ENV_TYPE', 'cmd');
                } else {
                    define('SYL_ENV_TYPE', 'web');
                }
            }
            $class_name = 'SyL_Controller' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Controller/{$class_name}.php";
            // ҥ饹Υ󥹥
            $singleton = new $class_name($config);
        }
        return $singleton;
    }

    /**
     * 
     *
     * @access protected
     */
    function initStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('initStream');
    }

    /**
     * ¹
     *
     * @access protected
     */
    function loadStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('loadStream');
    }

    /**
     * ¹
     *
     * @access protected
     */
    function executeStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('executeStream');
    }

    /**
     * ӥ塼ɽ¹
     *
     * @access protected
     */
    function middleStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('middleStream');
    }

    /**
     * ӥ塼ɽ
     *
     * @access protected
     */
    function renderStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('renderStream');
    }

    /**
     * ӥ塼ɽ¹Ը
     *
     * @access protected
     */
    function unloadStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('unloadStream');
    }

    /**
     * ǽ
     * register_shutdown_function
     *
     * @access protected
     */
    function finalStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('finalStream');
    }

    /**
     * 顼ϥɥ¹Խ
     *
     * @access protected
     */
    function errorStream()
    {
        static $num = 1;

        // ߤΥ顼٥뤫饨顼̤ɽ뤫Ƚ
        if (func_get_arg(0) & error_reporting()) {
            if ($num++ > 1) {
                echo "[SyL error] Error handler trigger 2";
                exit;
            }

            // ƥʤ˥顼ȯȲɽʤʤ뤿
            // 顼ɽϡob_clean() ǥꥢ롣
            echo "[SyL_error] Controller init error message: " . func_get_arg(1) . " file: " . func_get_arg(2) . " line: " . func_get_arg(3) . "\r\n";

            for ($i=0; $i<5; $i++) {
                $this->error[$i] = func_get_arg($i);
            }
            $this->error[5] = debug_backtrace();
            // errorStream()᥽åɤϺ
            array_shift($this->error[5]);

            // ٥ȼ¹
            $this->raiseEvent('errorStream');
            exit;
        } else {
            // 󥰤Ȥ
        }
    }

    /**
     * ȥݥ
     *
     * @access public
     */
    function stream()
    {
    }

    /**
     * ٥ȼ¹
     *
     * @access protected
     * @param string ٥ȥ᥽å̾
     * @param string ե̾
     */
    function raiseEvent($event, $config_type=array())
    {
        $this->container->raiseEvent($event, $config_type);
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ
     */
    function getActionDir()
    {
        return $this->action_dir;
    }

    /**
     * 顼No
     * 
     * @access public
     * @return string 顼No
     */
    function getErrorNo()
    {
        return isset($this->error[0]) ? $this->error[0] : '';
    }

    /**
     * 顼å
     * 
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        $error_message  = '';
        $error_message .= isset($this->error[1]) ? $this->error[1] : '';
        if (isset($this->error[2]) && isset($this->error[3])) {
            $error_message .= " ({$this->error[2]} on line {$this->error[3]})";
        }
        return $error_message;
    }

    /**
     * 顼ȯǤΤ٤ƤѿƤ
     * 
     * @access public
     * @return array 顼ƥ
     */
    function getErrorContext()
    {
        return isset($this->error[4]) ? $this->error[4] : array();
    }

    /**
     * 顼ȯǥХåȥ졼
     * 
     * @access public
     * @return array ǥХåȥ졼
     */
    function getErrorTrace()
    {
        return isset($this->error[5]) ? $this->error[5] : array();
    }
}

?>
