<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.2 2007/02/03 11:44:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptӥ塼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.2 2007/02/03 11:44:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewJs extends SyL_View
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewJs(&$dm)
    {
        parent::SyL_View($dm);
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        $request =& SyL_Request::getInstance();
        $mode = $request->getParameter('mode');
        $modes = array();
        if ($mode) {
            $modes = explode(',', $mode);
        } else {
            $modes = array();
        }

        $session =& $request->getSessionObject();

        include_once SYL_INCLUDE_DIR . '/lib/SyL_AjaxClient.php';
        $ajaxjs =& new SyL_AjaxClient();
        $ajaxjs->setSessionId($session->getSidQuery());
        $ajaxjs->setUrl($_SERVER['PHP_SELF']);
        $ajaxjs->setActionKey(SYL_ACTION_KEY);
        foreach ($modes as $mode) {
            $method = 'is' . ucfirst($mode);
            if (method_exists($ajaxjs, $method)) {
                $ajaxjs->$method(true);
            }
        }

        // JavaScirptƥĥ
        SyL_Response::setHeader('Content-Type', 'application/x-javascript; charset=' . SYL_ENCODE_INTERNAL);
        // JavaScirpt
        $this->setRender($ajaxjs->getJs());
    }
}

?>
