<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJsJson.php,v 1.2 2007/02/03 11:44:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

require_once 'SyL_ViewJs.php';

/**
 * Jsonӥ塼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJsJson.php,v 1.2 2007/02/03 11:44:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewJsJson extends SyL_ViewJs
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewJsJson(&$dm)
    {
        parent::SyL_ViewJs($dm);
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        if ($this->dm->getActionName() != '') {
            // ѥ᡼ϡJson֥Ȥ򥻥å
            if (!function_exists('json_encode')) {
                include_once SYL_INCLUDE_DIR . '/lib/SyL_Json.php';
            }
            $values     =& $this->getActionValues();
            $javascript = json_encode($values);
            $javascript = mb_convert_encoding($javascript, SYL_ENCODE_AJAX, SYL_ENCODE_INTERNAL);

            // JavaScirptƥĥ
            SyL_Response::setHeader('Content-Type', 'application/json; charset=' . SYL_ENCODE_AJAX);
            // JavaScirpt
            $this->setRender($javascript);
        } else {
            // ǥեȤJavaScriptɽ
            parent::render();
        }
    }
}

?>
