<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Ibsql.php,v 1.8 2007/01/21 08:14:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹Intrebase, Firebird
 *
 * Firebird 2.0 ʾ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Ibsql.php,v 1.8 2007/01/21 08:14:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DB_Ibsql extends SyL_DB
{
    /**
     * 󥳡Ѵơ֥
     *
     *  Firebird <=> PHP
     *  (client)     (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    var $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'eucj_0208'),
      array('euc-jp',    'eucj_0208'),
      array('sjis-win',  'sjis_0208' ),
      array('sjis',      'sjis_0208'),
      array('utf-8',     'unicode_fss')
    );

    /**
     * ȥ󥶥ID
     * 
     * @access private
     * @var int ȥ󥶥ID
     */
    var $transaction_id = null;
  
    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     @ @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        if ($host != '') {
            $dbname = $host . ':' . $dbname;
        }

        // ³Υ󥳡
        parent::setClientEncoding();

        if ($this->client_encode != '') {
            $this->connection = ($persistent) ? ibase_pconnect($dbname, $user, $passwd, $this->client_encode) : ibase_connect($dbname, $user, $passwd, $this->client_encode);
        } else {
            $this->connection = ($persistent) ? ibase_pconnect($dbname, $user, $passwd) : ibase_connect($dbname, $user, $passwd);
        }
        return is_resource($this->connection);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            ibase_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function getLastError()
    {
        return ibase_errmsg();
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function sanitize($parameter)
    {
        return !is_numeric($parameter) ? str_replace("'", "''", $parameter) : $parameter;
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function begin()
    {
        parent::begin();
        $this->transaction_id = ibase_trans(IBASE_DEFAULT, $this->connection);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollback()
    {
        ibase_rollback($this->transaction_id);
        $this->transaction_id = null;
        parent::rollback();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        ibase_commit($this->transaction_id);
        $this->transaction_id = null;
        parent::commit();
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function executeSelect($sql)
    {
        $result = @ibase_query($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * *** SQL¹Ͼtrue֤ ***
     *
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function executeUpdate($sql)
    {
        // ¹Ի顼Ƚ
        $result = @ibase_query($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeNoReturn($sql)
    {
        // ¹Ի顼Ƚ
        $result = @ibase_query($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeGet($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execute($sql, $query);

        // ¹Ի顼Ƚ
        if (is_resource($query)) {
            switch ($get) {
            // 1ե
            case 'one':
                list($data) = ibase_fetch_row($query);
                if ($data === false) {
                    $data = '';
                }
                break;
            // 1쥳
            case 'record':
                $data = ibase_fetch_assoc($query);
                if ($data === false) {
                    $data = array();
                } else {
                    $data = $this->changeFieldName($data);
                }
                break;
            // 쥳
            case 'all':
                $data = array();
                while ($result = ibase_fetch_assoc($query)) {
                  $data[] = $this->changeFieldName($result);
                }
              break;
            }
            ibase_free_result($query);
            return true;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     * ¹ˡinitializePageץ᥽åɼ¹ɬ
     * SQLʸΡFROM׶ľ˥ʸɬܡʤʳΥʸԲġ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function executePage($sql, &$result, &$page_control, $limit, $page=1)
    {
        // ڡ楯饹
        include_once dirname(dirname(__FILE__)) . '/SyL_Pager.php';
        $page_control = new SyL_Pager();
        $page_control->setCount($limit);
        $page_control->setPage($page);

        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->executeGet($sql_count, $record, 'one')) return false;
        $page_control->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        if (preg_match('/^(select)\s+(.+)$/i', trim($sql_page), $matches)) {
            $sql_page = $matches[1] . ' first ' . $page_control->getCount() . ' skip ' . $page_control->getStartRecord() . ' ' . $matches[2];
        }
        // ǡSQL¹
        return $this->executeGet($sql_page, $result, 'all');
    }

    /**
     * եեޥåȴؿ̾
     *
     * @access public
     *
     * @param string ̾
     * @param string շեޥå strtotimeեޥå
     * @return string եեޥåȴؿ̾
     */
    function getSqlDateFormat($column_name, $format='%Y-%m-%d %H:%M:%S')
    {
        ini_set('ibase.timestampformat', $format);
        return $column_name;
    }
}

?>
