<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigFilters.php,v 1.10 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륿եɤ߹९饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigFilters.php,v 1.10 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigFilters extends SyL_Config
{
    /**
     * ե륿٥ȡʥ
     * 
     * @access private
     * @var string
     */
    var $filter_event_before = 'loadStream';
    /**
     * ե륿٥ȡʥ塢ӥ塼ɽ
     * 
     * @access private
     * @var string
     */
    var $filter_event_mid = 'middleStream';
    /**
     * ե륿٥ȡʥӥ塼ɽ
     * 
     * @access private
     * @var string
     */
    var $filter_event_after = 'unloadStream';
    /**
     * ǥեȼ¹Խ
     * 
     * @param int
     */
    var $default_priority = 7;
    /**
     * ե̾
     * 
     * @access private
     * @var string
     */
    var $action_file = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     */
    function SyL_ConfigFilters($file_name)
    {
        // ƥ饹Υ󥹥ȥ饯
        parent::SyL_Config($file_name);
    }

    /**
     * ȥ򥻥å
     * С饤
     *
     * @access public
     * @param object ȥ饪֥
     */
    function setController(&$controller)
    {
        $dm =& $controller->container->getComponent('datamanager');
        $this->action_file = $dm->getActionFile();
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXML()
    {
        if (SYL_WEBAPP_CACHE_DIR) {
            // åѤ
            $key = implode('', $this->file_names) . $this->action_file;
            $cache =& SyL_Cache::getObject($key, 'fileupdate');
            $cache->setCacheDir(SYL_WEBAPP_CACHE_DIR . '/filters');
            $this->config = $cache->read($this->file_names);
            if (!$this->config) {
                parent::parseXML();
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXML();
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name  = '';
        static $method_name = '';

//echo $current_path . "<br>";

        // XMLϷ̤
        switch ($current_path) {
        case '/filters/filter':
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                $name = '';
                return;
            }

            // ̾ǧ
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            if (preg_match('/^' . $reg . '$/', $this->action_file)) {
                $name = '__filter_' . $attribute['name'];
                $this->config[$name]['class']     = $attribute['class'];
                $this->config[$name]['type']      = 'filter';
                $this->config[$name]['file']      = isset($attribute['file']) ? $attribute['file'] : '';
                $this->config[$name]['reference'] = false;
                // ¹Խ
                $this->config[$name]['priority'] = $this->default_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$name]['constructor'] = false;
                // ٥ȥʥ֥Ⱥ
                $this->config[$name]['event'][$this->event][] = $name;
                // 
                $this->config[$name]['args'] = array();
            } else {
                $name = '';
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/filters/filter/before':
               $method_name = 'method:' . $attribute['name'];
               // ٥ȥ
               $this->config[$name]['event'][$this->filter_event_before][] = $method_name;
               $this->config[$name]['args'][$method_name]  = array();
               break;

            case '/filters/filter/mid':
               $method_name = 'method:' . $attribute['name'];
               // ٥ȥ
               $this->config[$name]['event'][$this->filter_event_mid][] = $method_name;
               $this->config[$name]['args'][$method_name]  = array();
               break;

            case '/filters/filter/after':
               $method_name = 'method:' . $attribute['name'];
               // ٥ȥ
               $this->config[$name]['event'][$this->filter_event_after][] = $method_name;
               $this->config[$name]['args'][$method_name]  = array();
               break;

            case '/filters/filter/mid/arg':
            case '/filters/filter/before/arg':
            case '/filters/filter/after/arg':
               $type = isset($attribute['type']) ? $attribute['type'] : 'value';
               $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
               $this->config[$name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
               break;
            }
        }
    }
}

?>
