<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBIbase.php,v 1.2 2007/02/25 14:20:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹Intrebase, Firebird
 *
 * ڡ᥽åɤѤʤ顢Firebird 2.0 ʾ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBIbase.php,v 1.2 2007/02/25 14:20:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBIbase extends SyL_DB
{
    /**
     * 󥳡ɥե饰
     *
     * @access private
     * @var bool
     */
    var $client_encode_flag = false;

    /**
     * 󥳡Ѵơ֥
     *
     *  Firebird <=> PHP
     *  (client)     (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    var $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'eucj_0208'),
      array('euc-jp',    'eucj_0208'),
      array('euc',       'eucj_0208'),
      array('sjis-win',  'sjis_0208' ),
      array('sjis',      'sjis_0208'),
      array('utf-8',     'unicode_fss')
    );

    /**
     * ȥ󥶥ID
     * 
     * @access private
     * @var int ȥ󥶥ID
     */
    var $transaction_id = null;
  
    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     @ @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        if ($host != '') {
            $dbname = $host . ':' . $dbname;
        }

        if ($this->client_encode) {
            $this->connection = $persistent ? ibase_pconnect($dbname, $user, $passwd, $this->client_encode) : ibase_connect($dbname, $user, $passwd, $this->client_encode);
            $this->client_encode_flag = true;
        } else {
            $this->connection = $persistent ? ibase_pconnect($dbname, $user, $passwd) : ibase_connect($dbname, $user, $passwd);
        }
        return is_resource($this->connection);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            ibase_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    function setClientEncoding($client_encode, $server_encode='')
    {
        $this->client_encode_flag = false;
        parent::setClientEncoding($client_encode, $server_encode);
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        if ($code) {
            parent::setErrorMessage($code, $message);
        } else {
            if (function_exists('ibase_errcode')) {
                if (ibase_errcode()) {
                    $this->last_error_code    = ibase_errcode();
                    $this->last_error_message = ibase_errmsg();
                }
            } else {
                if (ibase_errmsg()) {
                    $this->last_error_code    = '9999';
                    $this->last_error_message = ibase_errmsg();
                }
            }
        }
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return str_replace("'", "''", $parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        parent::beginTransaction();
        $this->transaction_id = ibase_trans(IBASE_DEFAULT, $this->connection);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        ibase_rollback($this->transaction_id);
        $this->transaction_id = null;
        parent::rollBack();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        ibase_commit($this->transaction_id);
        $this->transaction_id = null;
        parent::commit();
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execRef($sql, &$result)
    {
        if (!$this->client_encode_flag) {
            $this->convertEncoding($sql);
        }
        parent::execRef($sql, $result);
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        $result = @ibase_query(($this->transaction_id ? $this->transaction_id : $this->connection), $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * *** SQL¹Ͼtrue֤ ***
     *
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        // ¹Ի顼Ƚ
        $result = @ibase_query((is_resource($this->transaction_id) ? $this->transaction_id : $this->connection), $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        return $this->execUpdate($sql);
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $query);

        // ¹Ի顼Ƚ
        if (!is_resource($query)) {
            $data = $query;
            return ($query !== false);
        }

        switch ($get) {
        // 1ե
        case 'one':
            list($data) = ibase_fetch_row($query);
            if ($data === false) {
                $data = '';
            }
            break;
        // 1쥳
        case 'record':
            $data = ibase_fetch_assoc($query);
            if ($data === false) {
                $data = array();
            } else {
                $data = $this->caseFieldName($data);
            }
            break;
        // 쥳
        case 'all':

            $data = array();
            while ($result = ibase_fetch_assoc($query)) {
              $data[] = $this->caseFieldName($result);
            }
          break;
        }
        ibase_free_result($query);

        if (!$this->client_encode_flag) {
            $this->convertDecoding($data);
        }

        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page = trim($sql);
        if (preg_match('/^(select)\s+(.+)$/i', $sql_page, $matches)) {
            $sql_page = $matches[1] . ' first ' . $pager->getCount() . ' skip ' . $pager->getStartOffset() . ' ' . $matches[2];
        } else {
            trigger_error("[SyL error] Ibase SQL invalid ({$sql_page})", E_USER_ERROR);
        }
        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * Ǹ줿Ԥ ID 뤤ϥ󥹤ͤ
     *
     * @access public
     * @return int Ǹ줿ԤID
     */
    function lastInsertId($seq='')
    {
        $sql = "SELECT GEN_ID({$seq}, 0) FROM rdb$database";
        $this->queryRef($sql, $data, 'one');
        return $data;
    }
}

?>
