<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlite.php,v 1.1 2007/02/22 12:55:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹SQLITE
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlite.php,v 1.1 2007/02/22 12:55:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSqlite extends SyL_DB
{
    /**
     * DBС󥳡
     * 
     * @access protected
     * @var string
     */
    var $server_encode = 'utf-8';

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        if ($this->field_case) {
            ini_set('sqlite.assoc_case', $this->field_case);
        }

        $func = $persistent ? 'sqlite_popen' : 'sqlite_open';
        $this->connection = $func($dbname, 0666, $error_msg);
        if (!$error_msg && is_resource($this->connection)) {
            return true;
        } else {
            $this->setErrorMessage('9999', $error_msg);
            $this->triggerError();
            return false;
        }
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            sqlite_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        if ($code) {
            parent::setErrorMessage($code, $message);
        } else {
            $code = sqlite_last_error($this->connection);
            if ($code != 0) {
                $this->last_error_code    = $code;
                $this->last_error_message = sqlite_error_string($code);
            }
        }
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return sqlite_escape_string($parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        parent::beginTransaction();
        @sqlite_exec($this->connection, 'BEGIN');
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        @sqlite_exec($this->connection, 'ROLLBACK');
        parent::rollBack();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        @sqlite_exec($this->connection, 'COMMIT');
        parent::commit();
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execRef($sql, &$result)
    {
        $this->convertEncoding($sql);
        return parent::execRef($sql, $result);
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        $error_code = null;
        $error_msg  = null;
        if (PHP_VERSION >= 5.1) {
            $result = @sqlite_query($this->connection, $sql, SQLITE_BOTH, $error_msg);
            if (!$result) {
                $error_code = '9999';
            }
        } else {
            $result = @sqlite_query($this->connection, $sql, SQLITE_BOTH);
        }

        if ($result !== false) {
            return $result;
        } else {
            $this->setErrorMessage($error_code, $error_msg);
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        $error_code = null;
        $error_msg  = null;
        if (PHP_VERSION >= 5.1) {
            $result = @sqlite_exec($this->connection, $sql, $error_msg);
            if (!$result) {
                $error_code = '9999';
            }
        } else {
            $result = @sqlite_exec($this->connection, $sql);
        }

        if ($result !== false) {
            return sqlite_changes($this->connection);
        } else {
            $this->setErrorMessage($error_code, $error_msg);
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        $error_code = null;
        $error_msg  = null;
        if (PHP_VERSION >= 5.1) {
            $result = @sqlite_exec($this->connection, $sql, $error_msg);
            if (!$result) {
                $error_code = '9999';
            }
        } else {
            $result = @sqlite_exec($this->connection, $sql);
        }

        if ($result !== false) {
            return true;
        } else {
            $this->setErrorMessage($error_code, $error_msg);
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all')
    {
        // Ƚ
        if (!$this->execRef($sql, $query) || !is_resource($query)) {
            $data = $query;
            return ($query !== false);
        }

        switch ($get) {
        case 'one':
            if (sqlite_num_rows($query) > 0) {
                $data = sqlite_fetch_single($query);
            } else {
                $data = '';
            }
            break;
        case 'record':
            $data = sqlite_fetch_array($query, SQLITE_ASSOC);
            if ($data === false) {
                $data = array();
            }
            break;
        case 'all':
            $data = sqlite_fetch_all($query, SQLITE_ASSOC);
            break;
        }
        $query = null;

        $this->convertDecoding($data);
        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        trigger_error("[SyL error] " . __METHOD__ . " method not implemented this class (" . __CLASS__ . ")", E_USER_ERROR);
    }

    /**
     * Ǹ줿Ԥ ID 뤤ϥ󥹤ͤ
     *
     * @access public
     * @return int Ǹ줿ԤID
     */
    function lastInsertId($seq='')
    {
        return sqlite_last_insert_rowid($this->connection);
    }
}

?>
