<?php

require_once dirname(__FILE__) . '/../../Http/SyL_HttpClientResult.php';

require_once 'SyL_XmlRpcClientReader.php';

/**
 * XML RPCNGXgʃNX
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientResult.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcClientResult extends SyL_HttpClientResult
{
    /**
     * ̕R[h
     *
     * @access protected
     * @var string
     */
    var $original_encode = 'UTF-8';
    /**
     * XMLRPC [_[IuWFNg
     *
     * @access private
     * @var object
     */
    var $reader = null;

    /**
     * RXgN^
     * 
     * @access public
     * @param string NGXg
     * @param string NCAgGR[h
     */
    function SyL_XmlRpcClientResult($data, $client_encode='')
    {
        parent::SyL_HttpClientResult($data, $client_encode);

        // 擪100oCgڂ܂łɃGR[fBO̒`擾
        if (preg_match ('/<\?xml(.*)encoding=\"(.+)\"(.*)\?>/i', substr(ltrim($this->body), 0, 100), $matches)) {
            $this->original_encode = $matches[2];
        }

        $this->reader =& new SyL_XmlRpcClientReader();
        if ($this->original_encode) {
            $this->reader->setXmlEncode($this->original_encode);
        }
        if ($this->client_encode) {
            $this->reader->setClientEncode($this->client_encode);
        }
        $this->reader->setData($this->body);
        $this->reader->parseXml();
    }

    /**
     * XML RPC̖߂l擾
     * 
     * @access public
     * @return mixed XML RPC̖߂l
     */
    function getReturn()
    {
        return $this->reader->getValue();
    }
}


?>
