<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActionscmd.php,v 1.7 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActionscmd.php,v 1.7 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigActionscmd extends SyL_Config
{
    /**
     * ǥեȼ¹Խ
     * 
     * @param int
     */
    var $default_priority = 5;
    /**
     * ޥɥ
     * 
     * @access private
     * @var string
     */
    var $actioncmd = '';
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * ݡͥȥ᥽åɥ֥
     * 
     * @access private
     * @var object
     */
    var $cm = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     */
    function SyL_ConfigActionscmd($file_name)
    {
        // ƥ饹Υ󥹥ȥ饯
        parent::SyL_Config($file_name);
    }

    /**
     * ȥ򥻥å
     * С饤
     *
     * @access public
     * @param object ȥ饪֥
     */
    function setController(&$controller)
    {
        $cmd =& $controller->container->getComponent('cmd');
        $actions = $cmd->getArg();
        $cnt = count($actions);
        if ($cnt > 1) {
            trigger_error("[SyL error] Invalid number of Action 0 or 1 ($cnt)", E_USER_ERROR);
        }
        $this->actioncmd = isset($actions[0]) ? $actions[0] : '*';

        $this->controller =& $controller;
        $this->cm         =& $controller->container->getComponent('componentmethod');
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        // 
        $config = array();
        foreach ($this->file_names as $file_name) {
            parent::setFile($file_name);
            parent::parseXml();
            $config += $this->config;
            // 
            $this->config = array();
        }

        $this->config = $config;
    }


    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name               = '';
        static $component_name     = '';
        static $component_priority = 0;
        static $method_name        = '';
        static $load               = false;

//echo $current_path . "<br>";
        // 1ɺѤߤξʹߥå
        if ($load) return;

        // XMLϷ̤
        switch ($current_path) {
        case '/actions/action':
            if ($name != '') {
                $name = '';
                $load = true;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                $name = '';
                return;
            }

            // ޥɳǧ
            if (($attribute['name'] == '*') || preg_match('/^' . str_replace('/', '\\/', $attribute['name']) . '$/', $this->actioncmd)) {
                $name = $this->actioncmd;
                $this->config[$name]['class']     = $attribute['class'];
                $this->config[$name]['type']      = 'actioncmd';
                $this->config[$name]['file']      = $this->controller->getActionDir() . $attribute['file'];
                $this->config[$name]['reference'] = true;
                // ¹Խ
                $this->config[$name]['priority'] = $this->default_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$name]['constructor'] = false;
                // ٥ȥʥ֥Ⱥ
                $this->config[$name]['event'][$this->event][] = $name;
                // 
                $this->config[$name]['args'] = array();

            } else {
                $name = '';
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/actions/action/method':
                if (!isset($this->config[$name]['args'])) {
                    $this->config[$name]['args'] = array();
                }
                $method_name = 'method:' . $attribute['name'];
                $this->config[$name]['args'][$method_name] = array();
                // ٥ȥ
                $this->config[$name]['event'][$this->event][] = $method_name;
                break;

            case '/actions/action/method/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $this->config[$name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                break;

           case '/actions/action/components/component':
                if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                    $component_name = '';
                    return;
                }
                $component_name = $attribute['name'];
                $this->config[$component_name]['class']     = $attribute['class'];
                $this->config[$component_name]['type']      = 'component';
                $this->config[$component_name]['file']      = isset($attribute['file']) ? $attribute['file'] : '';
                $this->config[$component_name]['reference'] = false;
                // ¹Խ(1ʳᤤ)
                $default_priority = $this->default_priority - 1;
                $component_priority = isset($attribute['priority']) ? floatval($default_priority . '.' . $attribute['priority']) : $default_priority;
                $this->config[$component_name]['priority'] = $component_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$component_name]['constructor'] = false;
                // ٥ȥ
                $this->config[$component_name]['event'][$this->event][] = $component_name;
                // 
                $this->config[$component_name]['args'] = array();

                // ץꥱ󥳥ݡͥ̾å
                $this->cm->addAppComponent($component_name, '', $component_priority);
                break;

            default:
                if (!$component_name) return;

                switch ($current_path) {
                case '/actions/action/components/component/constructor':
                    $method_name = 'constructor:' . (isset($attribute['static']) ? $attribute['static'] : '');
                    // 󥹥ȥ饯󥸥ե饰
                    $this->config[$component_name]['constructor'] = true;
                    // 󥹥ȥ饯󥸥ξ硢Υ᥽åɤϺ
                    $index = array_search($component_name, $this->config[$component_name]['event'][$this->event]);
                    if ($index !== false) {
                        unset($this->config[$component_name]['event'][$this->event][$index]);
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/actions/action/components/component/constructor/arg':
                    $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                    $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                    $this->config[$component_name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                    break;

                case '/actions/action/components/component/setter':
                    // 쥯ȥåȥ
                    if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                        $method_name = 'setter:' . $attribute['name'] . ':true';
                    } else {
                        $method_name = 'setter:set' . ucfirst(strtolower($attribute['name'])) . ':false';
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/actions/action/components/component/setter/arg':
                    $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                    $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                    $this->config[$component_name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                    break;

                case '/actions/action/components/component/method':
                    $method_name = 'method:' . $attribute['name'];
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/actions/action/components/component/method/arg':
                    $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                    $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                    $this->config[$component_name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                    break;

                case '/actions/action/components/component/final':
                    // ץꥱ󥳥ݡͥ̾å
                    $this->cm->addAppComponent($component_name, $attribute['name'], $component_priority);
                    break;
                }
            }
        }
    }
}

?>
