<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Response.php,v 1.10 2007/03/24 05:20:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̱饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Response.php,v 1.10 2007/03/24 05:20:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Response
{
    /**
     * ɲHTTP쥹ݥ󥹥إå
     * 
     * @access public
     * @var array
     */
    var $headers = array();

    /**
     * HTTP쥹ݥ󥹥֥Ȥ
     * 
     * @access public
     * @return object HTTP쥹ݥ󥹥֥
     */
    function &getInstance()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $class_name = __CLASS__;
            $singleton = new $class_name();
        }
        return $singleton;
    }

    /**
     * 쥯Ȥ
     *
     * RFCˤʤ٤ह褦ˡʼǤС˼ưURLåȤ
     * 
     * @static
     * @access public
     * @param string 쥯URL
     */
    function redirect($url, $pathinfo=null)
    {
        if (!preg_match('/^[a-z]+:\/\/(.+)/i', $url)) {
            $protocol = '';
            $server   = '';
            if (isset($_SERVER['SERVER_PORT']) && (($_SERVER['SERVER_PORT'] == '80') || ($_SERVER['SERVER_PORT'] == '443'))) {
                $protocol = ($_SERVER['SERVER_PORT'] == '80') ? 'http' : 'https';
            }
            if (isset($_SERVER['HTTP_HOST'])) {
                $server = $_SERVER['HTTP_HOST'];
            } else if (isset($_SERVER['SERVER_NAME'])) {
                $server = $_SERVER['SERVER_NAME'];
            }

            if ($protocol && $server) {
                if (substr($url, 0, 1) == '/') {
                    $url = "{$protocol}://{$server}{$url}";
                } else {
                    if ($pathinfo === null) {
                        $path = '';
                        if (($pathinfo === true) || (($pathinfo === null) && (strpos(SYL_ROUTER_RULE, 'pathinfo') !== false))) {
                            if (isset($_SERVER['PHP_SELF'])) {
                                $path = dirname($_SERVER['PHP_SELF']);
                            }
                        } else {
                            if (isset($_SERVER["SCRIPT_NAME"])) {
                                $path = dirname($_SERVER["SCRIPT_NAME"]);
                            }
                        }
                        if ($path) {
                            if ($path != '/') {
                                $path .= '/';
                            }
                            $path .= $url;
                            while (preg_match('/^(.+\/)([^\/]+\/\.\.\/)(.+)$/', $path, $matches)) {
                                $path = $matches[1] . $matches[3];
                            }
                            $path = str_replace('./', '', $path);
                            $url = "{$protocol}://{$server}{$path}";
                        }
                    }
                }
            }
        }

        if (SYL_ENV_TYPE == 'js') {
            // JSǻѤ硢301 ϥ֥饦٥ǥ쥯Ȥ뤿306
            SyL_Response::setStatusHeader('306');
            SyL_Loggers::info("[Response] Redirect(306) -> {$url}");
        } else {
            SyL_Response::setStatusHeader('301');
            SyL_Loggers::info("[Response] Redirect(301) -> {$url}");
        }
        SyL_Response::setHeader('Location', $url);
        $obj =& SyL_Response::getInstance();
        $obj->sendHeader();

        exit;
    }

    /**
     * 404 Not Found 쥯Ȥ
     *
     * @access public
     * @param string URL
     */
    function redirect404()
    {
        SyL_Response::setStatusHeader('404');
        if (SYL_ENV_TYPE == 'web') {
            $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
            SyL_Loggers::info("[Response] 404 Not Found - {$request_uri}");
            if (SYL_ERROR_URL_404) {
                SyL_Response::redirect(SYL_ERROR_URL_404);
            } else {
                echo "<h2>HTTP/1.0 404 Not Found</h2>";
            }
        }
        exit;
    }

    /**
     * HTTP쥹ݥ󥹥إå򥻥åȤ
     * 
     * @static
     * @access public
     * @param string إå̾
     * @param string إå
     */
    function setHeader($name, $value='')
    {
        $obj =& SyL_Response::getInstance();
        $obj->headers[$name] = $value;
    }

    /**
     * HTTP쥹ݥ󥹥ơإå򥻥åȤ
     * 
     * @static
     * @access public
     * @param string ơ
     * @param string إå
     */
    function setStatusHeader($status_code)
    {
        $status_header = SyL_Response::getStatusHeader($status_code);
        SyL_Response::setHeader($status_header);
    }

    /**
     * HTTP쥹ݥ󥹥إå
     * 
     * @static
     * @access public
     * @param string إå̾
     */
    function getHeader($name)
    {
        $name = strtolower($name);

        $obj =& SyL_Response::getInstance();
        foreach ($obj->getCustomHeaders() as $tmp_name => $tmp_value) {
            if ($name == strtolower($tmp_name)) {
                return $tmp_value;
            }
        }

        if (function_exists('headers_list')) {
            // 5.0
            foreach (headers_list() as $header) {
                $header_values = explode(':', $header, 2);
                if ($name == strtolower(trim($header_values[0]))) {
                    return trim($header_values[1]);
                }
            }
        } else if (function_exists('apache_response_headers')) {
            foreach (apache_response_headers() as $tmp_name => $tmp_value) {
                if ($name == strtolower($tmp_name)) {
                    return $tmp_value;
                }
            }
        }

        return false;
    }

    /**
     * HTTP쥹ݥ󥹥إå
     * 
     * @access public
     * @return array إå
     */
    function getCustomHeaders()
    {
        return $this->headers;
    }

    /**
     * HTTP쥹ݥ󥹥إå
     * 
     * @access public
     */
    function sendHeader()
    {
        foreach ($this->getCustomHeaders() as $tmp_name => $tmp_value) {
            if ($tmp_value) {
                header("$tmp_name: $tmp_value");
            } else {
                header("$tmp_name");
            }
        }
    }

    /**
     * gzip̤ѲǽʤѤ
     * 
     * @access public
     * @param string ϥǡ
     * @return bool true: gzip̡false: ̾
     */
    function convertGzip(&$data)
    {
        $convert = false;
        if (extension_loaded('zlib')) {
            if (isset($_SERVER['HTTP_ACCEPT_ENCODING']) && preg_match('/((x\-)?gzip)/', $_SERVER['HTTP_ACCEPT_ENCODING'], $matches)) {
                SyL_Response::setHeader('Content-Encoding', $matches[1]);
                SyL_Response::setHeader('Vary', 'Accept-Encoding');

                $size = strlen($data);
                $crc  = crc32($data);
                $data = gzcompress($data, SYL_RESPONSE_GZIP);
                $data = substr($data, 0, strlen($data) - 4);
                $data = "\x1f\x8b\x08\x00\x00\x00\x00\x00" . $data . pack('V', $crc) . pack('V', $size);
                $convert = true;
            }
        }
        return $convert;
    }

    /**
     * 󥰤줿HTML
     * 
     * @access public
     * @param object ӥ塼֥
     */
    function display(&$view)
    {
        if (is_object($view)) {
            $data           =& $view->getRender();
            $content_type   =  $view->getContentType();
            $content_length =  $view->isContentLength();
            $gzip_compress  =  $view->isGzipCompress();

            // ƥĥפ򥻥å
            if ($content_type) {
                SyL_Response::setHeader('Content-Type', $content_type);
            }

            // gzip̤ѲǽʤѤ
            if (!$gzip_compress || !$this->convertGzip($data)) {
                // gzip̤ʤ硢ƥ̤򥻥å
                if ($content_length) {
                    SyL_Response::setHeader('Content-Length', strlen($data));
                }
            }
        } else {
            $data =& $view;
        }

        // إå
        $this->sendHeader();
        // ɽǡ
        echo $data;

        // Хåե󥰽
        $neste = ob_get_level();
        for ($i=0; $i<$neste; $i++) {
            ob_end_flush();
        }

        // 
        $data = null;
    }

    /**
     * ơɤ饹ơإå
     * 
     * @static
     * @access public
     * @param string ơ
     * @param string HTTPС
     * @return string ơإå
     */
    function getStatusHeader($status_code, $http_version='1.0')
    {
        $message = '';
        switch ($status_code) {
        case '100': $message = 'Continue'; break;
        case '101': $message = 'Switching Protocols'; break;
        case '200': $message = 'OK'; break;
        case '201': $message = 'Created'; break;
        case '202': $message = 'Accepted'; break;
        case '203': $message = 'Non-Authoritative Information'; break;
        case '204': $message = 'No Content'; break;
        case '205': $message = 'Reset Content'; break;
        case '206': $message = 'Partial Content'; break;
        case '300': $message = 'Multiple Choices'; break;
        case '301': $message = 'Moved Permanently'; break;
        case '302': $message = 'Found'; break;
        case '303': $message = 'See Other'; break;
        case '304': $message = 'Not Modified'; break;
        case '305': $message = 'Use Proxy'; break;
        case '306': $message = '(Unused)'; break;
        case '307': $message = 'Temporary Redirect'; break;
        case '400': $message = 'Bad Request'; break;
        case '401': $message = 'Unauthorized'; break;
        case '402': $message = 'Payment Required'; break;
        case '403': $message = 'Forbidden'; break;
        case '404': $message = 'Not Found'; break;
        case '405': $message = 'Method Not Allowed'; break;
        case '406': $message = 'Not Acceptable'; break;
        case '407': $message = 'Proxy Authentication Required'; break;
        case '408': $message = 'Request Timeout'; break;
        case '409': $message = 'Conflict'; break;
        case '410': $message = 'Gone'; break;
        case '411': $message = 'Length Required'; break;
        case '412': $message = 'Precondition Failed'; break;
        case '413': $message = 'Request Entity Too Large'; break;
        case '414': $message = 'Request-URI Too Long'; break;
        case '415': $message = 'Unsupported Media Type'; break;
        case '416': $message = 'Requested Range Not Satisfiable'; break;
        case '417': $message = 'Expectation Failed'; break;
        case '500': $message = 'Internal Server Error'; break;
        case '501': $message = 'Not Implemented'; break;
        case '502': $message = 'Bad Gateway'; break;
        case '503': $message = 'Service Unavailable'; break;
        case '504': $message = 'Gateway Timeout'; break;
        case '505': $message = 'HTTP Version Not Supported'; break;
        default   : return false;
        }

        return "HTTP/{$http_version} {$status_code} {$message}";
    }
}

?>
