<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidator.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڸ̥饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidator.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidator extends SyL_Validation
{
    /**
     * ڥ
     *
     * @access protected
     * @var string
     */
    var $type = '';
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string 顼åΥեޥå
     * @param array ڥѥ᡼
     */
    function SyL_ValidationValidator($validate_name, $error_message, $parameters=array())
    {
        $this->type          = $validate_name;
        $this->error_message = $error_message;
        $this->parameters    = array_merge($this->parameters, $parameters);
    }

    /**
     * ̸ڥ֥Ȥμ
     *
     * @static
     * @access public
     * @param string ̾
     * @param string 顼å
     * @param array ڥѥ᡼
     * @return object ̸ڥ֥
     */
    function &create($type, $error_message, $parameters=array())
    {
        $classname =  'SyL_ValidationValidator' . ucfirst($type);
        include_once dirname(__FILE__) . "/Validator/{$classname}.php";
        $obj =& new $classname($type, $error_message, $parameters);
        return $obj;
    }

    /**
     * ڥѥ᡼򥻥å
     *
     * @access public
     * @param array ڥѥ᡼
     */
    function setParameters($parameters)
    {
        $this->parameters = array_merge($this->parameters, $parameters);
    }

    /**
     * ¨ڽ¹Ԥ
     *
     * @static
     * @access public
     * @param string ̾
     * @param string о
     * @param array ڥѥ᡼
     * @return bool true: 顼̵, false: 顼
     */
    function executeImmediate($validate_name, $value, $parameters=array())
    {
        $validator =& SyL_ValidationValidator::create($validate_name, '', $parameters);
        return $validator->execute($value);
    }

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @param string о̾
     * @return bool true: 顼̵, false: 顼
     */
    function execute($value, $name='')
    {
        // ɬܥå or եåʳǡͤξtrue
        if (!$this->isRequire()) {
            // ѿʤ      => SyL_ValidationValidatorRequire
            // 1ʤ => SyL_ValidationValidatorRequires
            // 2ʤ => SyL_ValidationValidatorRequiresFile
            // ...
            if (is_array($value)) {
                $func = is_array(current($value)) ? 'requiresfile' : 'requires';
            } else {
                $func = 'require';
            }
            if (!call_user_func(array(__CLASS__, 'executeImmediate'), $func, $value)) {
                return true;
            }
        }

        if (!$this->validate($value)) {
            $this->replaceErrorMessage($name);
            return false;
        } else {
            return true;
        }
    }

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param mixed о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
    }

    /**
     * 顼å
     *
     * @access public
     * @param string ̾
     */
    function replaceErrorMessage($name)
    {
        foreach ($this->parameters as $key => $value) {
            $this->error_message = str_replace('{' . $key . '}', $value, $this->error_message);
        }
        parent::replaceErrorMessage($name);
    }

    /**
     * ڽJavaScript
     *
     * @access public
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScript($display_name, $parts)
    {
        $this->replaceErrorMessage($display_name);
        return $this->getJavaScriptCode($parts);
    }

    /**
     * ڽJavaScript
     *
     * @access public
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScriptCode($parts)
    {
    }
}

/**
 * ꥢ
 */
class SyL_Validator extends SyL_ValidationValidator{}

?>
