<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorNumeric.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ϰϸڥ饹
 * 
 * 
 * $SyL_Validator =& SyL_Validator::create( 'range', '{name}{min}{max}δ֤ϤƤ', array( 'min' => 1, 'max' => '10' ) );
 *
 * 顼åѴʸ
 *  {min} : 
 *  {max} : 
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorNumeric.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorNumeric extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'min'       => null,
      'min_error' => null,
      'max'       => null,
      'max_error' => null
    );

    /**
     * ϰϸڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        if (!is_numeric($value)) {
            return false;
        }

        // Ǿ͸
        if ($this->parameters['min'] !== null) {
            if ((float)$value < (float)$this->parameters['min']) {
                if ($this->parameters['min_error'] !== null) {
                    $this->error_message = $this->parameters['min_error'];
                }
                return false;
            }
        }
  
        // ͸
        if ($this->parameters['max'] !== null) {
            if ((float)$value > (float)$this->parameters['max']) {
                if ($this->parameters['max_error'] !== null) {
                    $this->error_message = $this->parameters['max_error'];
                }
                return false;
            }
        }

        return true;
    }

    /**
     * ͸ڽJavaScript
     *
     * @access public
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScriptCode($parts)
    {
        $min       = $this->parameters['min'];
        $min_error = $this->parameters['min_error'];
        if ($min && $min_error) {
            $min_error = str_replace('{min}', $this->parameters['min'], $min_error);
        }
        $max = $this->parameters['max'];
        $max_error = $this->parameters['max_error'];
        if ($max && $max_error) {
            $max_error = str_replace('{max}', $this->parameters['max'], $max_error);
        }

        $js  = "";
        $js .= "if (!error_flag && !validator.isNumeric(element_name, '" . $this->getErrorMessage() . "', '{$min}', '{$min_error}', '{$max}', '{$max_error}')) { \r\n";
        $js .= "  error_flag = true; \r\n";
        $js .= "} \r\n";
        return $js;
    }
}

?>
