<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorRegex.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ɽڥ饹
 * 
 * 
 * $SyL_Validator =& SyL_Validator::create( 'regex', '{name}ޤ', array( 'regex' => '/^([0-9]{3}\-?[0-9]{4})$/' ));
 *
 * 顼åѴʸ
 *  ʤ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorRegex.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorRegex extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'format' => null
    );

    /**
     * ɽڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @param array ȥѥ᡼
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        if ($this->parameters['format'] !== null) {
            return preg_match($this->parameters['format'], $value);
        } else {
            return false;
        }
    }

    /**
     * ɽڽJavaScript
     *
     * @access public
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScriptCode($parts)
    {
        $js = '';
        $js .= 'if (!error_flag && !validator.isRegex(element_name, "' . $this->getErrorMessage() . '", ' . $this->parameters['format'] . ')) {' . "\r\n";
        $js .= '  error_flag = true;' . "\r\n";
        $js .= '}' . "\r\n";
        return $js;
    }
}

?>
