<?php
require_once dirname(__FILE__) . '/../SyL_XmlWriter.php';

/**
 * XML RPC饤ȥѥ᡼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientParameter.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcClientParameter extends SyL_HttpClientParameter
{
    /**
     * XMLRPC ᥽å̾
     *
     * @access private
     * @var string
     */
    var $method_name = '';

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string HTTPꥯоURL
     * @param string ꥯȥ᥽å
     */
    function SyL_XmlRpcClientParameter($url='/', $method='POST')
    {
        parent::SyL_HttpClientParameter($url, $method);
    }

    /**
     * ᥽å̾򥻥å
     * 
     * @access public
     * @param string ᥽å̾
     */
    function setMethod($method_name)
    {
        $this->method_name = $method_name;
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼
     * @param string 
     */
    function set($value, $format='')
    {
        static $i = 0;
        $format = $i++ . ':' . $format;
        parent::set($format, $value);
    }

    /**
     * եޥåȤѴ
     * 
     * @access public
     * @param string ѥ᡼
     * @param string 
     * @return string Ѵ巿
     */
    function encodeFormat($value, $format)
    {
        switch (strtolower($format)) {
        case 'string':  return 'string';
        case 'int':
        case 'i4':
        case 'number':  return 'int';
        case 'bool':
        case 'boolean': return 'boolean';
        case 'double':
        case 'float':   return 'double';
        case 'datetime':
        case 'datetime.iso8601': return 'dateTime.iso8601';
        case 'base64':
        case 'binary': return 'base64';
        case 'array':  return 'array';
        case 'struct': return 'struct';
        default:
            if ($format) {
                trigger_error("[SyL error] XmlRpc parameter format invalid ({$format})", E_USER_ERROR);
            }
            if (is_array($value)) {
                return ((count($value) == 0) || isset($value[0])) ? 'array' : 'struct';
            } else if (is_object($value)) {
                return 'struct';
            } else if (is_bool($value)) {
                return 'boolean';
            } else if (is_int($value)) {
                return 'int';
            } else if (is_float($value)) {
                return 'double';
            } else {
                return 'string';
            }
        }
    }

    /**
     * ͤѴ
     * 
     * @access public
     * @param string ѥ᡼
     * @param string 
     * @return mixed Ѵ
     */
    function encodeValue($value, $format)
    {
        switch ($format) {
        case 'struct':
            if (is_object($value)) {
                $values = array();
                foreach (get_object_vars($value) as $k => $v) {
                  $values[$k] = $v;
                }
                $value = $values;
            }
            return $value;
        case 'boolean':
            return ($value ? '1' : '0');
        case 'int':
        case 'double':
            return (string)$value;
        case 'dateTime.iso8601':
            if (preg_match('/^(\d{4})[\/\-]?(\d{2})[\/\-]?(\d{2})[ ]?(\d{2}):?(\d{2}):?(\d{2})$/', $value, $matches)) {
                $value = $matches[1] . $matches[2] . $matches[3] . 'T' . $matches[4] . ':' . $matches[5] . ':' . $matches[6];
            } else if (preg_match('/^(\d{4})[\/\-]?(\d{2})[\/\-]?(\d{2})$/', $value, $matches)) {
                $value = $matches[1] . $matches[2] . $matches[3] . 'T00:00:00';
            }
            return $value;
        default:
            return $value;
        }
    }


/*
<?xml version="1.0"?
<methodCall>
  <methodName>examples.getStateName</methodName>
  <params>
     <param>
        <value><i4>41</i4></value>
     </param>
   </params>
</methodCall>
*/

    /**
     * ѥ᡼ꥯȷѴ
     * 
     * @access public
     * @return string XMLǡ
     */
    function build()
    {
        $xml = new SyL_XmlWriter();
        $xml->isEol(true);
        $xml->addDeclaration();
        $xml->addStartElement('methodCall');
        $xml->addElement('methodName', array(), $this->method_name);
        $xml->addStartElement('params');
        foreach ($this->parameters->gets() as $name => $value) {
            $xml->addStartElement('param');
            $xml->addStartElement('value');
            list(, $format) = explode(':', $name, 2);
            $this->buildParameter($xml, $value, $format);
            $xml->addEndElement();
            $xml->addEndElement();
        }
        $xml->addEndElement();
        return $xml->create();
    }

    /**
     * ѥ᡼ƵŪѴ
     * 
     * @access public
     * @param object XML饤֥
     * @param string ѥ᡼
     * @param string 
     */
    function buildParameter(&$xml, $value, $format='')
    {
        $format = $this->encodeFormat($value, $format);
        $value  = $this->encodeValue($value, $format);
        if ($format == 'array') {
            $xml->addStartElement($format);
            $xml->addStartElement('data');
            foreach ($value as $tmp) {
                $this->buildParameter($xml, $tmp);
            }
            $xml->addEndElement();
            $xml->addEndElement();
        } else if ($format == 'struct') {
            $xml->addStartElement($format);
            foreach ($value as $tmp1 => $tmp2) {
                $xml->addStartElement('member');
                $xml->addElement('name', array(), $tmp1);
                $this->buildParameter($xml, $tmp2);
                $xml->addEndElement();
            }
            $xml->addEndElement();
        } else {
            $xml->addElement($format, array(), $value);
        }
    }
}

?>
