/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Ajax󥯥饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
function SyL_Login(id)
{
  this.id = id;
  this.url = "<?= $login_url ?>";
  this.username = "<?= $login_username ?>";
  this.password = "<?= $login_password ?>";
  this.hash = <?= $login_hash ?>;
  this.key  = "<?= $login_key ?>";

  this.username_label = "Username: ";
  this.password_label = "Password: ";
  this.username_value = "";
  this.password_value = "";

  this.onsubmit = null;

  // ¹ؿ
  this.loginPreFunc = this.doPreLogin;
  // ¹Ըؿ
  this.loginFailedFunc = this.doPostLogin;
}

SyL_Login.prototype = {
  /**
   * ե
   *
   * @access public
   */
  createForm: function(id)
  {
    var self = this;
    var div = document.getElementById(self.id);
    div.innerHTML = '';
    var form;
    if (id) {
      form = document.getElementById(id);
      if (self.username_value != "") {
        self.createPassword(form, div);
      } else {
        self.createUserName(form, div);
      }
    } else {
      form = document.createElement("form");
      div.appendChild(form);
      if (self.username_value != "") {
        self.createPassword(form);
      } else {
        self.createUserName(form);
      }
    }

    // ե
    setTimeout(function()
    {
      for (var i=0; i<form.elements.length; i++) {
        if (form.elements[i].value == "") {
          form.elements[i].focus();
          break;
        }
      }
    },
    200);
  },

  /**
   * 桼̾ϥƥȥܥå
   *
   * @access private
   * @param object 
   */
  createUserName: function(form, div)
  {
    var self    = this;
    var input   = document.createElement("input");
    input.type  = "text";
    input.name  = self.username;
    input.value = "";
    input.size  = "40";
    if (div) {
      div.appendChild(document.createTextNode(self.username_label));
      div.appendChild(input);
    } else {
      form.appendChild(document.createTextNode(self.username_label));
      form.appendChild(input);
    }

    self.onsubmit = form.onsubmit;
    form.onsubmit = function()
    {
      if ((this.elements[0].name == self.username) && (this.elements[0].value == "")) {
        alert("Incorrect " + self.username_label);
        this.elements[0].focus();
      } else {
        self.username_value = this.elements[0].value;
        self.createForm();
      }
      return false;
    };
  },

  /**
   * ѥϥѥɥܥå
   *
   * @access private
   * @param object 
   */
  createPassword: function(form, div)
  {
    var self    = this;
    var input   = document.createElement("input");
    input.type  = "password";
    input.name  = self.password;
    input.value = "";
    input.size  = "40";
    if (div) {
      div.appendChild(document.createTextNode(self.password_label));
      div.appendChild(input);
    } else {
      form.appendChild(document.createTextNode(self.password_label));
      form.appendChild(input);
    }

    form.onsubmit = function()
    {
      if (self.onsubmit) {
        self.onsubmit();
      }
      self.password_value = this.elements[0].value;
      self.authenticate(self.username_value, self.password_value);
      return false;
    };
  },

  /**
   * AjaxѤǧڤ¹Ԥ
   *
   * @access public
   * @param string 桼̾
   * @param string ѥ
   */
  authenticate: function(username_value, password_value)
  {
    var self = this;
    // ǧڼ¹ؿ
    if (!self.loginPreFunc(username_value, password_value)) {
      return;
    }
    // ϥå岽
    if (self.key && self.hash) {
      password_value = self.hash(self.key + self.hash(password_value));
    }
    var userinfo = {};
    userinfo[self.username] = username_value;
    userinfo[self.password] = password_value;

    // ǧڼ¹
    SyL_AjaxRequest.sendSyncPost(
      self.url,
      'login',
      function(result)
      {
        self.resultAuth();
      },
      null,
      userinfo
    );
  },

  /**
   * ǧڸ¹Դؿ
   *
   * @access private
   */
  resultAuth: function()
  {
    var self = this;
    // ǧڥ顼٥
    self.loginFailedFunc();

    self.username_value = "";
    self.password_value = "";
    if (self.id) {
      self.createForm();
    }
  },

  /**
   * ¹ؿ򥻥å
   *
   * @access public
   * @param object ¹ؿ
   */
  setLoginPreFunc: function(func)
  {
    this.loginPreFunc = func;
  },

  /**
   * ¹Ըؿ򥻥å
   *
   * @access public
   * @param object ¹Ըؿ
   */
  setLoginFailedFunc: function(func)
  {
    this.loginFailedFunc = func;
  },

  /**
   * ¹ؿ
   *
   * @access public
   * @param string 桼̾
   * @param string ѥ
   */
  doPreLogin: function(username, password)
  {
    return true;
  },

  /**
   * ¹ؿ
   *
   * @access public
   */
  doPostLogin: function()
  {
    alert("Login Failed...");
  }
}

