<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Error.php,v 1.20 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 顼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Error.php,v 1.20 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Error
{
    /**
     * 顼å
     * 
     * @access public
     * @var array
     */
    var $error_messages = array();
    /**
     * ԥ
     * 
     * @access public
     * @var string
     */
    var $eof = "\r\n";
    /**
     * ȥ
     * 
     * @access protected
     * @var object
     */
    var $controller = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ
     */
    function SyL_Error()
    {
    }

    /**
     * SyL_Error饹Υ󥹥󥹼
     *
     * singletonǥѤƤΤǡ
     * 1ĤΥ󥹥󥹤λȤ롣
     *
     * ˡ
     *   $SyL_Error =& SyL_Error::getInstance();
     *
     * @access public
     * @param object ȥ or ǡ֥
     */
    function &getInstance()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $classname = 'SyL_Error' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Error/{$classname}.php";
            // ҥ饹Υ󥹥
            $singleton = new $classname();
        }
        return $singleton;
    }

    /**
     * ȥ򥻥å
     *
     * @access public
     * @param object ȥ
     */
    function setController(&$controller)
    {
        $this->controller =& $controller;
    }

    /**
     * 顼ϥɥ
     * 
     * @static
     * @access public
     */
    function setErrorHandler()
    {
        $error =& SyL_Error::getInstance();
        if ($error->controller->error_handler_method) {
            if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
                set_error_handler(array(&$error->controller, $error->controller->error_handler_method), error_reporting());
                if ($error->controller->exception_handler_method) {
                    set_exception_handler(array(&$error->controller, $error->controller->exception_handler_method));
                }
            } else {
                set_error_handler(array(&$error->controller, $error->controller->error_handler_method));
            }
        }
    }

    /**
     * 顼ϥɥ
     * 
     * @static
     * @access public
     */
    function resetErrorHandler()
    {
        restore_error_handler();
    }

    /**
     * 顼å򥻥å
     * 
     * @static
     * @access public
     * @param string 顼å
     */
    function setErrorMessage($error_message)
    {
        $error =& SyL_Error::getInstance();
        $error->error_messages[] = $error_message;
    }

    /**
     * 顼å
     * 
     * @access protected
     */
    function getErrorMessages()
    {
        $error_message = $this->controller->getErrorMessage();
        if ($error_message) {
            $error_message = '[' . $this->getErrorType() . '] ' . $error_message;
            return array_merge($this->error_messages, (array)$error_message);
        } else {
            return $this->error_messages;
        }
    }

    /**
     * Ǥ̥顼̤ɽ
     * 
     * @static
     * @access public
     * @param string 顼å
     * @param int 顼٥
     */
    function trigger($error_string='', $error_type=E_USER_ERROR)
    {
        trigger_error($error_string, $error_type);
    }

    /**
     * 顼ϥɥ顼μ
     *
     * ƥץ졼ȥ᥽åɥѥΥƥץ졼
     * 
     * @access public
     */
    function errorHandler()
    {
        // Хåե󥰥ꥢ
        if (!headers_sent() && (ob_get_level() > 0)) {
            ob_clean();
        }

        // 顼å
        $error_messages = SYL_ERROR ? $this->getErrorMessages() : array(SYL_ERROR_MESSAGE);
        // 顼ȥ졼μ
        $error_trace = SYL_ERROR_TRACE ? $this->getTrace() : '';

        // ֥饹
        $this->displayError($error_messages, $error_trace);

        // 
        $this->log();
        // 顼᡼
        $this->sendMail();
    }

    /**
     * Ķ̥顼
     * 
     * @access public
     * @param array 顼å
     * @param array 顼ȥ졼
     */
    function displayError($error_messages, $error_trace)
    {
    }

    /**
     * 顼פ֤
     * ºݤ˥ץǥϥɥ󥰤ǤΤ
     *   E_WARNING
     *   E_NOTICE
     *   E_USER_ERROR
     *   E_USER_WARNING
     *   E_USER_NOTICE
     * Τ
     *
     * @access public
     * @param  int    顼No
     * @return string 顼̾
     */
    function getErrorType()
    {
        switch ($this->controller->getErrorNo()) {
        case E_ERROR           : return 'Error';
        case E_WARNING         : return 'Warning';
        case E_PARSE           : return 'Parsing Error';
        case E_NOTICE          : return 'Notice';
        case E_CORE_ERROR      : return 'Core Error';
        case E_CORE_WARNING    : return 'Core Warning';
        case E_COMPILE_ERROR   : return 'Compile Error';
        case E_COMPILE_WARNING : return 'Compile Warning';
        case E_USER_ERROR      : return 'User Error';
        case E_USER_WARNING    : return 'User Warning';
        case E_USER_NOTICE     : return 'User Notice';
        default:
            if (defined('E_STRICT') && ($errorNo == E_STRICT)) {
                return 'Strict';
            }
            if (defined('E_RECOVERABLE_ERROR') && ($errorNo == E_RECOVERABLE_ERROR)) {
                return 'Recoverable Error';
            }
        }

        return 'unknonwn';
    }

    /**
     * ȥ졼
     *
     * @access public
     * @return array ȥ졼
     */
    function getTrace()
    {
        // 顼ȥ졼
        $error_trace = array();
        $i = 1;
        foreach (array_reverse($this->controller->getErrorTrace()) as $values) {
            // 桼顼ϡtrigger_error״ؿʹߤӽ
            // ¾Υ顼ϡerrorhandler״ؿʹߤӽ
            if (isset($values['class']) && (strtolower($values['class']) == strtolower(get_class($this)))) {
                break;
            }
            $tmp = array();
            $tmp['no']   = $i++;
            $tmp['file'] = isset($values['file']) ? $values['file'] : '-';
            $tmp['line'] = isset($values['line']) ? $values['line'] : '-';
            if (isset($values['class']) && isset($values['type'])) {
                $tmp['function'] = $values['class'] . $values['type'] . $values['function'];
            } else {
                $tmp['function'] = (isset($values['function']) && ($values['function'] != 'unknown')) ? $values['function'] : '-';
            }
            $error_trace[] = $tmp;
        }

        return array_reverse($error_trace);
    }

    /**
     * 顼ȥ졼դ顼å
     * 󥰡᡼
     *
     * @access prvate
     * @return string 顼ȥ졼դ顼å
     */
    function getErrorMessageTrace()
    {
        $error_message = '[' . $this->getErrorType() . '] ' . implode($this->eof, $this->getErrorMessages()) . $this->eof;
        foreach ($this->getTrace() as $values) {
            $error_message .= "[file] "     . $values['file']     . " ";
            $error_message .= "[line] "     . $values['line']     . " ";
            $error_message .= "[function] " . $values['function'] . $this->eof;
        }
        return $error_message;
    }

    /**
     * 顼ե
     *
     * @access protected
     * @return string 顼ե
     */
    function getErrorFile()
    {
        return $this->controller->getErrorFile();
    }

    /**
     * 顼Կ
     *
     * @access protected
     * @return int 顼Կ
     */
    function getErrorLine()
    {
        return $this->controller->getErrorLine();
    }


    /**
     * 󥰤¸
     *
     * @access public
     */
    function log()
    {
        // ȥ졼դ顼å
        $error_message  = $this->getErrorMessageTrace();
        // 顼٥˥¸
        switch ($this->controller->getErrorNo()) {
        case E_ERROR:
        case E_USER_ERROR:
            SyL_Loggers::error($error_message);
            break;
        case E_WARNING:
        case E_USER_WARNING:
            SyL_Loggers::warn($error_message);
            break;
        case E_NOTICE:
        case E_USER_NOTICE:
            SyL_Loggers::notice($error_message);
            break;
        }
    }

    /**
     * 顼᡼
     *
     * @access public
     */
    function sendMail()
    {
        if (($this->controller->getErrorNo() <= SYL_DEBUG) && SYL_ERROR_MAIL && (SYL_MAIL_ADMIN_ADDRESS != '')) {
            // ռ
            $date = date('Y-m-d H:i:s');
            // С̾
            $server = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '';
            if ($server == '') {
                $server = isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : '';
            }

            $request_uri = isset($_SERVER['REQUEST_URI'])     ? $_SERVER['REQUEST_URI']     : '';
            $user_agent  = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
            $server_software = isset($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : '';

            // ȥ졼դ顼å
            $error_message  = $this->getErrorMessageTrace();
            // SyLΥС
            $version     = SYL_VERSION;
            $version_php = PHP_VERSION;
            $uname = php_uname();

            $error_mail_subject = "PHP Error occurred - {$server}";
            $error_mail_body = <<< EOF
SyL Framework Error info.
----------------------------------------
DATE: {$date}
SERVER: {$server}
REQUEST_URI: {$request_uri}
HTTP_USER_AGENT: {$user_agent}

{$error_message}

----------------------------------------
SyL Framework ver. {$version} on PHP {$version_php}
{$server_software}
{$uname}
EOF;

            // 顼᡼¹
            include_once SYL_INCLUDE_DIR . '/lib/SyL_Mail.php';
            $mail =& SyL_Mail::getObject(SYL_MAIL_TYPE);
            $mail->setSubject($error_mail_subject);
            $mail->setFrom(SYL_MAIL_ADMIN_ADDRESS);
            $mail->addTo(SYL_MAIL_ADMIN_ADDRESS);
            $mail->setBody($error_mail_body);
            if (!$mail->send()) {
                SyL_Loggers::error($mail->getErrorMessage());
            }
        }
    }
}

?>
