function SyL_FormValidater(f)
{
  // ե४֥
  this.f = f;
  // 顼ǳǼ
  this.errorElements = [];
  // 顼Ǽ
  this.errorMessages = [];
}

SyL_FormValidater.prototype = {
  /**
   * ͤ
   *
   * @access private
   * @param string ̾
   * @return mixed 
   */
  getValue: function(name)
  {
    var n = this.f.elements[name];
    var value = null;
    var type = '';
    if (this.f.elements[name][0] && this.f.elements[name][0].type) {
      type = this.f.elements[name][0].type;
    } else {
      type = this.f.elements[name].type;
    }

    switch (type) {
    case "select-one":
      var i = n.selectedIndex;
      if (i && i >= 0) {
        value = n.options[i].value;
      }
      break;
    case "select-multiple":
      value = [];
      for (var i=0; i<n.options.length; i++) {
        if (n.options[i].selected) {
          value.push(n.options[i].value);
        }
      }
      break;

    case "text":
    case "textarea":
    case "hidden":
    case "password":
      value = n.value;
      break;
    case "file":
      var len = n.length;
      if (len) {
        value = [];
        for (var i=0; i<len; i++) {
          value.push(n[i].value);
        }
      } else {
        value = n.value;
      }
      break;

    case "radio":
      var len = n.length;
      if (len) {
        for (var i=0; i<len; i++) {
          if (n[i].checked) {
            value = n[i].value;
            break;
          }
        }
      } else {
        if (n.checked) {
          value = n.value;
        }
      }
      break;
    case "checkbox":
      var len = n.length;
      if (len) {
        value = [];
        for (var i=0; i<len; i++) {
          if (n[i].checked) {
            value.push(n[i].value);
          }
        }
      } else {
        if (n.checked) {
          value = n.value;
        }
      }
      break;
    }

    return value;
  },

  /**
   * Ƚꤹ
   *
   * @access private
   * @param mixed 
   * @return true: , false: ʳ
   */
  isArray: function (value)
  {
    return value instanceof Array;
  },

  /**
   * ̤ϡ̤˥åԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isRequire: function(name, errorMessage, options)
  {
    if (!options || !options['trim']) options['trim'] = false;

    // ͼ
    var value = this.getValue(name);

    // 顼å¹
    var valid = true;
    if (this.isArray(value)) {
      var min_valids = (options && options['min_valids']) ? options['min_valids'] : 0;
      var max_valids = (options && options['max_valids']) ? options['max_valids'] : 0;

      var ok = 0;
      var len = value.length;
      for (var i=0; i<len; i++) {
        if (options['trim']) {
          value[i] = value[i].replace(/^\s+|\s+$/g, "");
        }
        if ((value[i] != null) && (value[i] != "")) {
          ok++;
        }
      }

      if (max_valids == 0) {
          max_valids = len;
          if (min_valids == 0) {
              min_valids = len;
          }
      }
      valid = ((max_valids >= ok) && (min_valids <= ok));
    } else {
      if (options['trim']) {
        value = value.replace(/^\s+|\s+$/g, "");
      }
      valid = ((value != null) && (value != ""));
    }

    // 顼Ƚ
    if (!valid && errorMessage) {
      this.setErrorMessage(name, errorMessage);
    }

    return valid;
  },

  /**
   * ӥåԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isCompare: function(name, errorMessage, options)
  {
    if (!options || !options['compare']) options['compare'] = '==';
    if (!options || !options['element']) options['element'] = null;
    if (!options || !options['value'])   options['value']   = null;

    // ͼ
    var value = this.getValue(name);

    // ͼ
    var target = '';
    if (options['element']) {
      target = this.getValue(options['element']);
    } else {
      target = options['value'];
    }

    // 顼å¹
    var valid = true;
    if (this.isArray(value)) {
      //var min_valids = (options && options['min_valids']) ? options['min_valids'] : 0;
      //var max_valids = (options && options['max_valids']) ? options['max_valids'] : 0;

      var target1 = [];
      if (this.isArray(target)) {
        target1 = target;
      } else {
        target1[0] = target;
      }

      var len  = value.length;
      if (len == target1.length) {
        for (var i=0; i<len; i++) {
          if (options['compare'].match(/^(!=|==|!==|===)$/)) {
             eval('valid = ("' + value[i].replace('"', '\\"') + '" ' + options['compare'] + ' "' + target1[i].replace('"', '\\"') + '");');
          } else if (options['compare'].match(/^(<=|>=|>|<)$/)) {
             eval('valid = (parseFloat("' + value[i].replace('"', '\\"') + '") ' + options['compare'] + ' parseFloat("' + target1[i].replace('"', '\\"') + '"));');
          } else {
              valid = false;
          }

          if (!valid) {
            break;
          }
        }
      } else {
        valid = false;
      }
    } else {
      var target1 = '';
      if (this.isArray(target)) {
        if (target.length == 1) {
          target1 = target[0];
        } else {
          valid = false;
        }
      } else {
        target1 = target;
      }

      if (options['compare'].match(/^(!=|==|!==|===)$/)) {
         eval('valid = ("' + value.replace('"', '\\"') + '" ' + options['compare'] + ' "' + target1.replace('"', '\\"') + '");');
      } else if (options['compare'].match(/^(<=|>=|>|<)$/)) {
         eval('valid = (parseFloat("' + value.replace('"', '\\"') + '") ' + options['compare'] + ' parseFloat("' + target1.replace('"', '\\"') + '"));');
      } else {
          valid = false;
      }
    }

    // 顼Ƚ
    if (!valid && errorMessage) {
      this.setErrorMessage(name, errorMessage);
    }

    return valid;
  },

  /**
   * ȾѿͥåԤ
   *
   * 0Ť, ǽ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isNumeric: function(name, errorMessage, options)
  {
    // ̤Ϥξtrue
    if (!this.isRequire(name, null, {'min_valids': '0', 'max_valids': '0'})) {
      return true;
    }

    if (!options || !options['format']) options['format'] = /^([0-9]+\.?[0-9]*)$/;
    if (!options || !options['min']) options['min'] = null;
    if (!options || !options['max']) options['max'] = null;
    if (!options || !options['min_error']) options['min_error'] = null;
    if (!options || !options['max_error']) options['max_error'] = null;

    // åɽ
    var regex = options['format'];
    // ͼ
    var value = this.getValue(name);

    // 顼å¹
    var valid = true;
    if (this.isArray(value)) {
      var min_valids = (options && options['min_valids']) ? options['min_valids'] : 0;
      var max_valids = (options && options['max_valids']) ? options['max_valids'] : 0;

      var ok = 0;
      var len = value.length;
      for (var i=0; i<len; i++) {
        if (value[i].match(regex)) {
          var t = true;
          if (options['min']) {
            if (options['min'] > value[i]) {
              t = false;
            }
          }
          if (t && options['max']) {
            if (value[i] > options['max']) {
              t = false;
            }
          }
          if (t) {
            ok++;
          }
        }
      }

      if (max_valids == 0) {
          max_valids = len;
          if (min_valids == 0) {
              min_valids = len;
          }
      }
      valid = ((max_valids >= ok) && (min_valids <= ok));
    } else {
      valid = value.match(regex);
      if (valid) {
        if (options['min']) {
          if (options['min'] > value) {
            valid = false;
            if (options['min_error']) {
              errorMessage = options['min_error'];
            }
          }
        }
        if (options['max']) {
          if (value > options['max']) {
            valid = false;
            if (options['max_error']) {
              errorMessage = options['max_error'];
            }
          }
        }
      }
    }

    // 顼Ƚ
    if (!valid && errorMessage) {
      this.setErrorMessage(name, errorMessage);
    }

    return valid;
  },

  /**
   * ɽåԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isRegex: function(name, errorMessage, options)
  {
    // ̤Ϥξtrue
    if (!this.isRequire(name, null, {'min_valids': '0', 'max_valids': '0'})) {
      return true;
    }

    if (!options || !options['format']) options['format'] = false;

    // ͼ
    var value = this.getValue(name);

    // 顼å¹
    var valid = true;
    if (this.isArray(value)) {
      var min_valids = (options && options['min_valids']) ? options['min_valids'] : 0;
      var max_valids = (options && options['max_valids']) ? options['max_valids'] : 0;

      var ok = 0;
      var len = value.length;
      for (var i=0; i<len; i++) {
        if (options['format'] && value.match(options['format'])) {
          ok++;
        }
      }

      if (max_valids == 0) {
          max_valids = len;
          if (min_valids == 0) {
              min_valids = len;
          }
      }
      valid = ((max_valids >= ok) && (min_valids <= ok));
    } else {
      if (options['format']) {
        valid = value.match(options['format']);
      } else {
        valid = false;
      }
    }

    // 顼Ƚ
    if (!valid && errorMessage) {
      this.setErrorMessage(name, errorMessage);
    }

    return valid;
  },

  /**
   * ХȿåԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isLength: function(name, errorMessage, options)
  {
    // ̤Ϥξtrue
    if (!this.isRequire(name, null, {'min_valids': '0', 'max_valids': '0'})) {
      return true;
    }

    if (!options || !options['min']) options['min'] = null;
    if (!options || !options['max']) options['max'] = null;
    if (!options || !options['min_error']) options['min_error'] = null;
    if (!options || !options['max_error']) options['max_error'] = null;

    // ͼ
    var value = this.getValue(name);

    // 顼å¹
    var valid = true;
    if (this.isArray(value)) {
      var min_valids = (options && options['min_valids']) ? options['min_valids'] : 0;
      var max_valids = (options && options['max_valids']) ? options['max_valids'] : 0;

      var ok = 0;
      var len = value.length;
      for (var i=0; i<len; i++) {
        var bytes = this.getBytes(value[i]);
        var t = true;
        if (options['min']) {
          if (options['min'] > bytes) {
            t = false;
          }
        }
        if (t && options['max']) {
          if (bytes > options['max']) {
            t = false;
          }
        }
        if (t) {
          ok++;
        }
      }

      if (max_valids == 0) {
          max_valids = len;
          if (min_valids == 0) {
              min_valids = len;
          }
      }
      valid = ((max_valids >= ok) && (min_valids <= ok));
    } else {
      var bytes = this.getBytes(value);
      if (options['min']) {
        if (options['min'] > bytes) {
          valid = false;
          if (options['min_error']) {
            errorMessage = options['min_error'];
          }
        }
      }
      if (options['max']) {
        if (bytes > options['max']) {
          valid = false;
          if (options['max_error']) {
            errorMessage = options['max_error'];
          }
        }
      }
    }

    // 顼Ƚ
    if (!valid && errorMessage) {
      this.setErrorMessage(name, errorMessage);
    }
  },

  /**
   * դå
   *
   * ǯǻ
   *
   * @param  å̾ǯ(string)
   * @param  å̾(string)
   * @param  å̾(string)
   * @param  åե̾(string)
   * @return true: , false: 顼(bool)
   */
  isDate: function (yName, mName, dName, displayName)
  {
    // ͼ
    var value_y = this.getValue(yName);
    var value_m = this.getValue(mName);
    var value_d = this.getValue(dName);

    // ̤Ϥξtrue
    if (((value_y == null) || (value_y == "")) ||
       ((value_m == null) || (value_m == ""))  ||
       ((value_d == null) || (value_d == ""))) {
      return true;
    }

    // ͥ顼å
    if (!this.isNumeric( yName, displayName + "ǯ" )) {
      return false;
    } else if (!this.isNumeric( mName, displayName + "η" )) {
      return false;
    } else if (!this.isNumeric( dName, displayName + "" )) {
      return false;
    }

    value_y = parseInt( value_y, "10" );
    value_m = parseInt( value_m, "10" ) -1;
    value_d = parseInt( value_d, "10" );

    // դå
    var tmpDate = new Date(value_y, value_m, value_d);
    var errorFlag = ( (value_y == tmpDate.getFullYear()) && (value_m == tmpDate.getMonth()) );

    // 顼Ƚ
    if (!errorFlag) {
      this.setErrorMessage( dName, displayName + "դޤ" );
    }

    return errorFlag;
  },

  /**
   * Хȿ
   *
   * UTF-16ΥХȿȽ
   * Ⱦѥʤ2ХȤȤ
   * 
   * @access public
   * @param string Хȼо
   * @return int Хȿ
   */
  getBytes: function(value)
  {
    var bytes = 0;

    for (var i=0; i<value.length; i++) {
      // c < 0x7E
      //   ASCIIϰ
      bytes += (value.charCodeAt(i) <= 0x7E) ? 1 : 2;
    }
    return bytes;
  },

  /**
   * 顼뤫Ƚꤹ
   *
   * @access public
   * @return bool true: 顼, false: 顼̵
   */
  isError: function()
  {
    return (this.errorMessages.length > 0);
  },

  /**
   * 顼å򥻥åȤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   */
  setErrorMessage: function(name, errorMessage)
  {
    this.errorElements.push(name);
    this.errorMessages.push(errorMessage);
  },

  /**
   * 顼å
   *
   * @access public
   * @return array 顼å
   */
  getErrorMessages: function()
  {
    this.errorMessages;
  },

  /**
   * 顼åɽ
   *
   * @access public
   * @param bool 顼ɽե饰
   * @param bool 顼ե饰
   * @param string 顼ɽID
   * @param string 顼åإå
   * @param string 顼åեå
   */
  displayErrorMessage: function (displayAll, autoFocus, id, header, footer)
  {
    // 顼̵Ͻλ
    if (!this.isError()) {
      return;
    }

    if (!displayAll) {
      displayAll = false;
    }
    if (!autoFocus) {
      autoFocus = false;
    }

    // ̵trueξϡɽ
    var displayMessage = (displayAll) ? this.errorMessages.join("\n") : this.errorMessages.shift();
    displayMessage = header + displayMessage + footer

    // 顼åɽ
    if (id && id != '') {
      document.getElementById(id).innerHTML = displayMessage.replace(new RegExp("\n", "g"), "<br>");
    } else {
      alert(displayMessage);
    }

    // ե
    if (autoFocus) {
      var name = this.errorElements.shift();
      this.focusElement(name);
      this.selectElement(name);
    }
  },

  /**
   * Ǥե
   *
   * @access public
   * @param string ̾
   */
  focusElement: function(name)
  {
    if (this.f.elements[name][0]) {
      this.f.elements[name][0].focus();
    } else {
      this.f.elements[name].focus();
    }
  },

  /**
   * Ǥ򤹤
   *
   * @access public
   * @param string ̾
   */
  selectElement: function(name)
  {
    switch (this.f.elements[name].type) {
    case "text":
    case "textarea":
    case "password":
    case "file":
      this.f.elements[name].select();
      break;
    }
  }
}
