<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcBuilderServer.php,v 1.1 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPCXML饹
 */
require_once 'SyL_XmlRpcBuilder.php';

/**
 * XMLRPCѥ쥹ݥ󥹺饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcBuilderServer.php,v 1.1 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcBuilderServer extends SyL_XmlRpcBuilder
{
    /**
     * 顼
     * 
     * @access private
     * @var int
     */
    var $error_code = 0;
    /**
     * 顼å
     * 
     * @access private
     * @var array
     */
    var $error_message = '';

    /**
     * 顼ɤ򥻥åȤ
     *
     * @access public
     * @oaram int 顼
     */
    function setErrorCode($error_code)
    {
        $this->error_code = $error_code;
    }

    /**
     * 顼å򥻥åȤ
     *
     * @access public
     * @oaram string 顼å
     */
    function setErrorMessage($error_message)
    {
        $this->error_message = $error_message;
    }

    /**
     * XMLRPC
     * 
     * @access public
     * @param object XML饤֥
     */
    function buildXml(&$xml)
    {
        $xml->addStartElement('methodResponse');
        if ($this->error_code == 0) {
            $xml->addStartElement('params');

            $parameter = $this->gets();
            if (count($parameter) > 0) {
                list($name, $value) = each($parameter);
                $xml->addStartElement('param');
                $xml->addStartElement('value');
                list(, $format) = explode(':', $name, 2);
                $this->buildParameter($xml, $value, $format);
                $xml->addEndElement();
                $xml->addEndElement();
            }
            $xml->addEndElement();

        } else {
            $xml->addStartElement('fault');
            $xml->addStartElement('value');
            $xml->addStartElement('struct');

            $xml->addStartElement('member');
            $xml->addElement('name', array(), 'faultCode');
            $xml->addStartElement('value');
            $xml->addElement('int', array(), $this->error_code);
            $xml->addEndElement();
            $xml->addEndElement();

            $xml->addStartElement('member');
            $xml->addElement('name', array(), 'faultString');
            $xml->addStartElement('value');
            $xml->addElement('string', array(), $this->error_message);
            $xml->addEndElement();
            $xml->addEndElement();

            $xml->addEndElement();
            $xml->addEndElement();
            $xml->addEndElement();
        }
        $xml->addEndElement();
    }
}

?>
