<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterConvertEncoding.php,v 1.3 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륿饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Filter.php';

/**
 * SyLĶɽե륿饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterConvertEncoding.php,v 1.3 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FilterConvertEncoding extends SyL_Filter
{
    /**
     * ꥯȥѥ᡼ʸɤѴ
     *
     * @access public
     * @param object ꥯȥ֥
     * @param string 󥳡
     * @param string ѥ᡼Υ󥳡
     */
    function preAction(&$data, $to_encoding, $from_encoding=null)
    {
        if ($from_encoding) {
            $data->apply('mb_convert_encoding', $to_encoding, $from_encoding);
        } else {
            $data->apply('mb_convert_encoding', $to_encoding);
        }
    }

    /**
     * ѥ᡼ʸɤѴ
     *
     * @access public
     * @param object ǡޥ͡㥪֥
     * @param string 󥳡
     * @param string ѥ᡼Υ󥳡
     */
    function postAction(&$data, $to_encoding, $from_encoding=null)
    {
        $this->preAction($data, $to_encoding, $from_encoding);
    }

    /**
     * ɽӥ塼ʸɤѴ
     *
     * @access public
     * @param object ӥ塼֥
     * @param string 󥳡
     * @param string ӥ塼Υ󥳡
     */
    function preRender(&$view, $to_encoding, $from_encoding=null)
    {
        $render =& $view->getRender();
        $content_type = trim($view->getContentType());
        // content-type Ѵ
        if ($content_type) {
            if (preg_match('/^(.+;[ ]*charset=)(.+)$/i', $content_type, $matches)) {
                $content_type = $matches[1] . $to_encoding;
            } else {
                if (substr($content_type, -1) != ';') {
                    $content_type .= ';';
                }
                $content_type .= " charset={$to_encoding}";
            }
            $view->setContentType($content_type);
        }
        if ($from_encoding) {
            $render = mb_convert_encoding($render, $to_encoding, $from_encoding);
        } else {
            $render = mb_convert_encoding($render, $to_encoding);
        }
    }
}

?>
