<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterXmlrpc.php,v 1.2 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML᥽åɤե졼ͤ륯饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterXmlrpc.php,v 1.2 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RouterXmlrpc extends SyL_Router
{
    /**
     * ζڤʸ
     *
     * @access private
     * @var string
     */
    var $action_delimiter = '.';

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * @access protected
     * @param object ꥯȥ֥
     */
    function createProperty(&$data)
    {
         // syl_xmlrpc_method => SyL_DataXmlrpc饹ǥåȤ
        $pathinfo = explode($this->action_delimiter, $data->get('syl_xmlrpc_method'));

        switch (count($pathinfo)) {
        case 0:
            $this->action_name = '';
            $this->action_file = '/' . $this->action_file_default;
            break;
        case 1:
            $this->action_name = array_pop($pathinfo);
            $this->action_file = '/' . $this->action_file_default;
            break;
        default:
            $this->action_name =  array_pop($pathinfo);
            $this->action_file = '/' . implode('/', $pathinfo) . $this->exe_ext;
            array_pop($pathinfo); // ե̾
            break;
        }

        // PATH_INFO
        $this->pathinfo = $pathinfo;

        // 饹ե
        if ($this->action_file != '') {
            $classname = implode('_', array_map('ucfirst', $this->pathinfo));
            if ($classname != '') {
                $this->class_name = $classname . '_' . ucfirst(basename($this->action_file, $this->exe_ext));
            } else {
                $this->class_name = ucfirst(basename($this->action_file,$this->exe_ext));
            }
        }
    }

}

?>
