<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutSmarty.php,v 1.6 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤ȥӥ塼饹
 */
require_once 'SyL_ViewLayout.php';
/**
 * Smarty饹
 */
require_once SYL_SMARTY_DIR . 'Smarty.class.php';

/**
 * Smarty쥤ȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutSmarty.php,v 1.6 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewLayoutSmarty extends SyL_ViewLayout
{
    /**
     * Smarty֥
     * 
     * @var object
     */
    var $smarty = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewLayoutSmarty(&$context, &$data)
    {
        parent::SyL_ViewLayout($context, $data);

        $compile_dir = SYL_SMARTY_COMPILE_DIR . basename(SYL_APP_DIR);
        if (!is_dir($compile_dir)) {
            trigger_error("[SyL error] Smarty compile_dir not found ({$compile_dir})", E_USER_ERROR);
        }
        $this->smarty =& new Smarty();
        $this->smarty->compile_dir = $compile_dir;
        $this->smarty->config_dir  = SYL_SMARTY_CONFIG_DIR;
        $this->smarty->cache_dir   = SYL_SMARTY_CACHE_DIR;
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        // 󤫤Υѥ᡼
        $values =& $this->getActionValues();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key])) {
                $this->smarty->assign_by_ref($key, $values[$key]);
            } else {
                $this->smarty->assign($key, $values[$key]);
            }
        }

        // ӥ塼ɽ󥯥롼ɥե
        foreach ($this->getIncludeFiles() as $include_file) {
            include_once $include_file;
        }

        // ƥץ졼ȥǥ쥯ȥꥻå
        $this->smarty->template_dir = $this->getTemplateDir();
        // ɽƤ򥻥å
        $this->setRender($this->smarty->fetch($this->getTemplateFile()));
    }
}

?>
