<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBMysqli.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹MySQLi
 *
 * MySQL 4.1ʾ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBMysqli.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBMysqli extends SyL_DB
{
    /**
     * MySQLΥС4.1ʾ
     *
     * @access private
     * @vat bool
     */
     private $ismore41 = false;

    /**
     * 󥳡Ѵơ֥
     *
     *  MySQL    <=> PHP
     *  (client)     (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    public $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'ujis'),
      array('euc-jp',    'ujis'),
      array('euc',       'ujis'),
      array('sjis-win',  'sjis' ),
      array('sjis',      'sjis'),
      array('utf-8',     'utf8')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    public function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        if (!$host) {
            $host = 'localhost';
        }
        if ($port) {
            $this->connection = mysqli_connect($host, $user, $passwd, $dbname, $port);
        } else {
            $this->connection = mysqli_connect($host, $user, $passwd, $dbname);
        }
        if (is_object($this->connection)) {
            $this->ismore41 = (mysqli_get_server_version($this->connection) >= 40100);
            return true;
        } else {
            return false;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    public function setClientEncoding($client_encode, $server_encode='')
    {
        if ($this->ismore41) {
            $client_encode2 = strtolower($client_encode);
            foreach ($this->encode_table as $encode_table) {
                if ($encode_table[0] == $client_encode2) {
                    $client_encode2 = $encode_table[1];
                    break;
                }
            }
            @mysqli_query($this->connection, "SET NAMES {$client_encode2}");
        }
        parent::setClientEncoding($client_encode, $server_encode);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    public function closeConnection()
    {
        if (is_object($this->connection)) {
            mysqli_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    public function setErrorMessage($code='', $message='')
    {
        if ($code) {
            parent::setErrorMessage($code, $message);
        } else {
            $code = mysqli_errno($this->connection);
            if ($code != 0) {
                $this->last_error_code    = $code;
                $this->last_error_message = mysqli_error($this->connection);
            }
        }
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    public function escape($parameter)
    {
        return mysqli_real_escape_string($this->connection, $parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    public function beginTransaction()
    {
        parent::beginTransaction();
        mysqli_autocommit($this->connection, false);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    public function rollBack()
    {
        mysqli_rollback($this->connection);
        mysqli_autocommit($this->connection, true);
        parent::rollBack();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    public function commit()
    {
        mysqli_commit($this->connection);
        mysqli_autocommit($this->connection, true);
        parent::commit();
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function execRef($sql, &$result)
    {
        if (!$this->ismore41) {
            $this->convertEncoding($sql);
        }
        parent::execRef($sql, $result);
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    public function execSelect($sql)
    {
        $result = @mysqli_query($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    public function execUpdate($sql)
    {
        $result = @mysqli_query($this->connection, $sql);
        if ($result !== false) {
            return mysqli_affected_rows($this->connection);
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function execNoReturn($sql)
    {
        $result = @mysqli_query($this->connection, $sql);
        if ($result !== false) {
            return true;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $query);

        // Ƚ
        if (!is_object($query)) {
            $data = $query;
            return ($query !== false);
        }

        switch ($get) {
        case 'one':
            if (mysqli_num_rows($query) > 0) {
                list($data) = mysqli_fetch_row($query);
            } else {
                $data = '';
            }
            break;
        case 'record':
            $data = mysqli_fetch_assoc($query);
            if ($data === false) {
                $data = array();
            } else {
                $data = $this->caseFieldName($data);
            }
            break;
        case 'all':
            $data = array();
            while ($result = mysqli_fetch_assoc($query)) {
                $data[] = $this->caseFieldName($result);
            }
            break;
        }
        mysqli_free_result($query);

        if (!$this->ismore41) {
            $this->convertDecoding($data);
        }

        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    public function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        if ($this->ismore41) {
            trigger_error("[SyL error] " . __METHOD__ . " method MySQL ver 4.1 more only", E_USER_ERROR);
        } else {
            $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        }
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= ' LIMIT ' . $pager->getStartOffset() . ', ' . $pager->getCount();

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    public function getVersion()
    {
        $version = mysqli_get_server_info($this->connection);
        list($version) = explode('-', $version);
        return $version;
    }
}

?>
