<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementRadio.php,v 1.9 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 饸ܥեǥ饹
 *
 * ̾ : ̾ : ̾(name) : (value)
 *   1  :      n     :    1         :  n
 *
 * 󥹥󥹺ˡ
 * // 쥯饹饹ƥå᥽åɤǼ
 * $SyL_FormElementText = SyL_FormElement::createElement( 'radio', 'gender', array( '1'=> '', '2' => '' ) );
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementRadio.php,v 1.9 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementRadio extends SyL_FormElement
{
    /**
     * ٥ID̾
     *
     * @access private
     * @var string
     */
    var $label = '_radio';
    /**
     * Ǵ֤ζڤʸ
     *
     * @access private
     * @var string
     */
    var $separator = "&nbsp;\r\n";

    /**
     * Ǵ֤ζڤʸ򥻥å
     *
     * @access public
     * @param string Ǵ֤ζڤʸ
     */
    function setSeparator($separetor)
    {
        $this->separator = $separetor;
    }

    /**
     * եHTML
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        $this->setAttribute($this->name, 'name');
        $this->setAttribute($this->type, 'type');

        $i = 0;
        $options = array();
        foreach ($this->options as $key => $value) {
            $id = $this->label . '_' . $this->name . '_' . $i;
            $this->setAttribute($id, 'id');
            $this->setAttribute($key, 'value');
            $checked = ($key == $this->value) ? 'checked' : '';

            $options[] = '<input ' . $this->getAttributes() . ' ' . $checked . ' /><label for="' . $id . '">' . $this->encode($value) . '</label>';
            $i++;
        }

        return implode($this->separator, $options);
    }

    /**
     * եHTML
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        $label = '';
        foreach ($this->options as $key => $value) {
            if ($key == $this->value) {
                $label = $value;
                break;
            }
        }
        return $this->encode($label) . $this->getHtmlHidden();
    }
}

?>
