<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClientResult.php,v 1.1 2007/03/17 13:53:08 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTPꥯȷ̥饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClientResult.php,v 1.1 2007/03/17 13:53:08 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_HttpClientResult
{
    /**
     * 쥹ݥ󥹥ǡ
     *
     * @access protected
     * @var string
     */
    var $data = '';
    /**
     * 쥹ݥ󥹥إå
     *
     * @access protected
     * @var array
     */
    var $headers = array();
    /**
     * 쥹ݥʸ
     *
     * @access protected
     * @var string
     */
    var $body = '';
    /**
     * ʸ
     *
     * @access protected
     * @var string
     */
    var $original_encode = '';
    /**
     * ʸ
     *
     * @access protected
     * @var string
     */
    var $client_encode = '';
    /**
     * 
     *
     * @access protected
     * @var string
     */
    var $eol = "\r\n";

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string ꥯȷ
     * @param string 饤ȥ󥳡
     */
    function SyL_HttpClientResult($data, $client_encode='')
    {
        $this->data = $data;
        $data       = explode($this->eol . $this->eol, $data, 2);
        $compress   = '';
        foreach (explode($this->eol, $data[0]) as $header) {
          $header = trim($header);
          if (preg_match('/^Content-Type:(.+)charset\=([^ ]+)(.*)/i', $header, $matches)) {
              $this->original_encode = trim($matches[2]);
          } else if (preg_match('/^Content-Encoding:(.+)/i', $header, $matches)) {
              $compress = trim($matches[1]);
          }
          $this->headers[] = $header;
        }
        if (isset($data[1])) {
            switch ($compress) {
            case 'gzip':    $this->body = gzuncompress($data[1]); break;
            case 'deflate': $this->body = gzinflate($data[1]);    break;
            default:        $this->body = $data[1];
            }
        }
        if ($client_encode) {
            $this->client_encode = $client_encode;
        }
        if (!$this->client_encode) {
            $this->client_encode = mb_internal_encoding();
        }
    }

    /**
     * 쥹ݥ󥹥ǡ
     * 
     * @access public
     * @return string 쥹ݥ󥹥ǡ
     */
    function getResponseData()
    {
        return $this->data;
    }

    /**
     * ʸɤ
     * 
     * @access public
     * @return string ʸ
     */
    function getClientEncode()
    {
        return $this->client_encode;
    }

    /**
     * 쥹ݥ󥹥ơ
     * 
     * @access public
     * @return string 쥹ݥ󥹥ơ
     */
    function getResponseStatus()
    {
        if (isset($this->headers[0])) {
            preg_match('/^HTTP\/1\.\d ([^ ]+) +./', $this->headers[0], $matches);
            return $matches[1];
        } else {
            return '';
        }
    }

    /**
     * 쥹ݥ󥹥إåǧ
     * 
     * @access public
     * @param string 쥹ݥ󥹥إå̾
     * @return bool true: 쥹ݥ󥹥إåꡢfalse: 쥹ݥ󥹥إå̵
     */
    function isHeader($name)
    {
        foreach ($this->headers as $header) {
            $reg = '/^' . preg_quote($name, '/') . '/';
            if (preg_match($reg, $header)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 쥹ݥ󥹥إå
     * 
     * @access public
     * @param string 쥹ݥ󥹥إå̾
     * @return array 쥹ݥ󥹥إå
     */
    function getHeader($name)
    {
        $headers = array();
        foreach ($this->headers as $header) {
            $reg = '/^' . preg_quote($name, '/') . ': (.+)/';
            if (preg_match($reg, $header, $matches)) {
                $headers[] = $matches[1];
            }
        }
        return $headers;
    }

    /**
     * 쥹ݥʸ
     * 
     * @access public
     * @return string 쥹ݥʸ
     */
    function getBody()
    {
        return $this->body;
    }

}

?>
