<?php
/**
 * ץꥱ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: application.php,v 1.6 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Application
{
    var $c_action; // 󥸥
    var $c_application; // 󥸥
    var $c_controller; // 󥸥
    var $c_template; // 󥸥

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Application()
    {
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     * @param object ݡͥȥ᥽åɥ֥
     */
    function execute(&$data, &$context)
    {
        $project_dir     = $data->get('d');
        $app_name        = $data->get('w');
        $controller_file = $data->get('c');
        //$action_files    = $data->get('a');
        //$template_files  = $data->get('t');

        $cmd =& $context->getConsole();

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cnt = count($project_dir);
        if ($cnt == 0) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Project directory (-d) only 1", E_USER_ERROR);
            exit;
        }

        $project_dir = preg_match('/(\\\\|\/)$/', $project_dir[0]) ? $project_dir[0] : $project_dir[0] . '/';

        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $cnt = count($app_name);
        if ($cnt == 0) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Application name (-w) only 1", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name[0])) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        } else {
            $app_name = $app_name[0];
        }

        $app_dir = $project_dir . 'app/' . $app_name . '/';

        if (file_exists($app_dir)) {
            if ($cmd->getInput('', "create application ({$app_dir}) [Y/n]:") != 'Y') {
                exit;
            }
            if (!is_writable($app_dir)) {
                trigger_error("[SyL error] Application directory permission denied ({$app_dir})", E_USER_ERROR);
                exit;
            }
        } else {
            if ($cmd->getInput('', "create directory ({$app_dir}) [Y/n]:") != 'Y') {
                exit;
            }
        }

        // -------------------------------------------------
        // ȥեå
        // -------------------------------------------------
        $cnt = count($controller_file);
        if ($cnt == 0) {
            $controller_file = '';
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Controller file (-c) only 1", E_USER_ERROR);
            exit;
        } else {
            $controller_file = $controller_file[0];
        }

        if ($controller_file) {
            if (file_exists($controller_file)) {
                if ($cmd->getInput('Already controller file exists', "overwrite controller file ({$controller_file}) [Y/n]:") != 'Y') {
                    exit;
                }
                if (!is_writable($controller_file)) {
                    trigger_error("[SyL error] Create controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            } else {
                if (!is_writable(dirname($controller_file))) {
                    trigger_error("[SyL error] Create controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            }
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        $action_files = array('index');

        // -------------------------------------------------
        // ƥץ졼ȥեå
        // -------------------------------------------------
        $template_files = array('index');

        // -------------------------------------------------
        // ץꥱ
        // -------------------------------------------------
        $this->c_application->trigger($project_dir, $app_name);

        // -------------------------------------------------
        // ȥե
        // -------------------------------------------------
        if ($controller_file) {
            $this->c_controller->trigger($project_dir, $app_name, $controller_file);
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        if (count($action_files) > 0) {
            $this->c_action->trigger($project_dir, $app_name, $action_files);
        }

        // -------------------------------------------------
        // ƥץ졼ȥե
        // -------------------------------------------------
        if (count($template_files) > 0) {
            $this->c_template->trigger($project_dir, $app_name, $template_files);
        }
    }

}

?>
