<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthDB.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_DB.php';

/**
 * DBǧڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthDB.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AuthDB extends SyL_Auth
{
    /**
     * 󥢥Ƚ
     * 
     * @access public
     * @return bool true: 󥢥󤢤ꡢfalse: 󥢥ʤ
     */
    function isLoginAction()
    {
        return (($_SERVER['REQUEST_METHOD'] == 'POST') && isset($_POST[$this->username]) && isset($_POST[$this->password]));
    }

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
         $client_username = isset($_POST[$this->username]) ? $_POST[$this->username] : '';
         $client_password = isset($_POST[$this->password]) ? $_POST[$this->password] : '';

         $parameters = explode(':', SYL_AUTH_TYPE_PARAMETER, 5);
         if (!isset($parameters[3])) $parameters[3] = '';
         if (!isset($parameters[4])) $parameters[4] = '';

         $conn =& SyL_DB::getConnection(SYL_DB_DSN);

         $sql  = "";
         $sql .= "SELECT ";
         $sql .=   $parameters[2] . " ";
         $sql .= "FROM ";
         $sql .=   $parameters[0] . " ";
         $sql .= "WHERE ";
         $sql .=   $parameters[1] . " = '" . $conn->escape($client_username) . "' ";
         if ($parameters[4]) {
         $sql .=   " AND " . $parameters[4] . " ";
         }

         $conn->queryRef($sql, $server_password, 'one');

         // ѥȽ
         return $this->isLoginPassword($client_username, $client_password, $server_password, (bool)$parameters[3]);
    }
}

?>
