<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigComponents.php,v 1.14 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݡͥեɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigComponents.php,v 1.14 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigComponents extends SyL_Config
{
    /**
     * ٥̾
     * 
     * @access private
     * @var string
     */
    var $event = 'initStream';
    /**
     * ǥեȼ¹Խ
     * 
     * @access private
     * @param int
     */
    var $default_priority = 3;

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_WEBAPP_CACHE_DIR) {
            // åѤ
            $cache =& $this->getCacheObject(SYL_WEBAPP_CACHE_DIR . 'components');
            if ($cache) {
                parent::parseXml();
                $cache->write($this->getCache());
            }
        } else {
            // åѤʤ
            parent::parseXml();
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name  = '';
        static $event = '';
        static $method_name = '';

//echo $current_path . "<br>";

        // XMLϷ̤
        switch ($current_path) {
        case '/syl-components/component':
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                $name = '';
                return;
            }
            $name = $attribute['name'];
            $this->config[$name]['type']      = 'component';
            $this->config[$name]['class']     = isset($attribute['class'])  ? $attribute['class']  : $name;
            $this->config[$name]['file']      = $attribute['file'];
            $this->config[$name]['reference'] = (isset($attribute['reference']) && ($attribute['reference'] === 'true'));
            // ¹Խ
            $this->config[$name]['priority'] = isset($attribute['priority']) ? (int)$attribute['priority'] : $this->default_priority;
            // 󥹥ȥ饯󥸥ե饰
            $this->config[$name]['constructor'] = false;
            // ե뤬¸ߤʤȥ顼Υե饰
            $this->config[$name]['force'] = false;
            // ٥ȥ
            $event = isset($attribute['event']) ? $attribute['event'] : $this->event;
            $this->config[$name]['event'][$event][] = $name;
            // 
            $this->config[$name]['args'] = array();
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/syl-components/component/constructor':
                $method_name = 'constructor:' . (isset($attribute['static']) ? $attribute['static'] : '');
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$name]['constructor'] = true;
                // ٥ȥ
                $event = isset($attribute['event']) ? $attribute['event'] : $event;
                // 󥹥ȥ饯󥸥ξ硢Υ᥽åɤϺ
                $index = array_search($name, $this->config[$name]['event'][$event]);
                if ($index !== false) {
                    unset($this->config[$name]['event'][$event][$index]);
                }
                $this->config[$name]['event'][$event][] = $method_name;
                $this->config[$name]['args'][$method_name] = array();
                break;

            case '/syl-components/component/constructor/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $this->config[$name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                break;

            case '/syl-components/component/setter':
                // 쥯ȥåȥ
                if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                    $method_name = 'setter:' . $attribute['name'] . ':true';
                } else {
                    $method_name = 'setter:set' . ucfirst(strtolower($attribute['name'])) . ':false';
                }
                // ٥ȥ
                $event = isset($attribute['event']) ? $attribute['event'] : $event;
                $this->config[$name]['event'][$event][] = $method_name;
                $this->config[$name]['args'][$method_name] = array();
                break;

            case '/syl-components/component/setter/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $this->config[$name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                break;

            case '/syl-components/component/method':
                $method_name = 'method:' . $attribute['name'];
                // ٥ȥ
                $event = isset($attribute['event']) ? $attribute['event'] : $event;
                $this->config[$name]['event'][$event][] = $method_name;
                $this->config[$name]['args'][$method_name] = array();
                break;

            case '/syl-components/component/method/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $this->config[$name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                break;
            }
        }
    }
}

?>
