<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestCookie.php,v 1.9 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Util/SyL_UtilProperty.php';

/**
 * åݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestCookie.php,v 1.9 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RequestCookie extends SyL_UtilProperty
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RequestCookie()
    {
        // ѥ᡼
        $this->parameters =& $_COOKIE;
        // ޥåݥȤͭȽ
        if (get_magic_quotes_gpc()) {
            $this->apply('stripslashes');
        }
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string ѥ᡼
     * @param int åͭ
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function set($name, $value, $expire=SYL_COOKIE_EXPIRE, $path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        // ñѴ y: ǯm: d: h: i: ʬs: 
        if (preg_match('/^(\d+)([ymdhis])$/', $expire, $match)) {
            switch ($match[2]) {
            case 'y': $expire = $match[1] * (strtotime('+1 year') - time());   break;
            case 'm': $expire = $match[1] * (strtotime('+1 month') - time());  break;
            case 'd': $expire = $match[1] * (strtotime('+1 day') - time());    break;
            case 'h': $expire = $match[1] * (strtotime('+1 hour') - time());   break;
            case 'i': $expire = $match[1] * (strtotime('+1 minute') - time()); break;
            case 's': $expire = $match[1] * (strtotime('+1 second') - time()); break;
            }
        }
        setcookie($name, $value, $expire, $path, $domain, $secure);
        parent::set($name, $value);
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function delete($name, $path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        setcookie($name, '', time()-3600, $path, $domain, $secure);
        parent::delete($name);
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function deletes($path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        foreach ($this->parameters as $name => $value) {
            $this->delete($name, $path, $domain, $secure);
        }
        parent::deletes();
    }
}

?>
