<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdosqlite.php,v 1.3 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹PDO
 */
require_once 'SyL_DBPdo.php';

/**
 *  DB饹PDO::sqlite
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdosqlite.php,v 1.3 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBPdosqlite extends SyL_DBPdo
{
    /**
     * DBС󥳡
     * 
     * @access protected
     * @var string
     */
    var $server_encode = 'utf-8';

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    public function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $conn_dbtype  = substr($this->dbname, 3);
        $conn_strings = array();
        $conn_user    = null;
        $conn_passwd  = null;
        if ($dbname) $conn_strings[] = $dbname;

        $conn_string = $conn_dbtype . ':' . implode(';', $conn_strings);
        return $this->pdoConnection($conn_string, $conn_user, $conn_passwd);
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function execRef($sql, &$result)
    {
        $this->convertEncoding($sql);
        return parent::execRef($sql, $result);
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function queryRef($sql, &$data, $get='all')
    {
        if (parent::queryRef($sql, $data, $get)) {
            $this->convertDecoding($data);
            return true;
        } else {
            return false;
        }
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     * ¹ˡinitializePageץ᥽åɼ¹ɬ
     * SQLʸΡFROM׶ľ˥ʸɬܡʤʳΥʸԲġ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    public function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= ' LIMIT ' . $pager->getStartOffset() . ', ' . $pager->getCount();

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    public function getVersion()
    {
        return '3';
    }
}

?>
