<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Cache.php,v 1.12 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * LbVNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Cache.php,v 1.12 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Cache
{
    /**
     * LbṼL[
     *
     * @access protected
     * @var string
     */
    var $key = '';
    /**
     * LbṼL[MD5
     *
     * @access protected
     * @var string
     */
    var $key_md5 = '';
    /**
     * LbV̗L
     * Pʂ͕b[s]
     *
     * @access protected
     * @var int
     */
    var $life_time = 86400; // 1day

    /**
     * LbVIuWFNg擾
     *
     * @static
     * @access public
     * @param string LbṼL[
     * @param string LbV^Cv
     */
    function &getObject($type='file')
    {
        $classname = 'SyL_Cache' . ucfirst($type);
        include_once dirname(__FILE__) . "/Cache/{$classname}.php";
        $obj =& new $classname();
        return $obj;
    }

    /**
     * LbṼL[Zbg
     *
     * @access public
     * @param string LbVL[
     */
    function setKey($key)
    {
        $this->key     = $key;
        $this->key_md5 = md5($key);
    }

    /**
     * LbVLԂZbg
     *
     * @access public
     * @param int LbVLԁib[s]j
     */
    function setLifeTime($life_time)
    {
        $this->life_time = $life_time;
    }

    /**
     * LbVLԂiiɁj
     *
     * @access public
     */
    function persistentLifeTime()
    {
        $this->setLifeTime(null);
    }

    /**
     * LbV̍XVԂXV
     *
     * @access public
     * @param int XV(UNIX Time)
     * @return bool true: XVOKAfalse: XVG[
     */
    function setModifyTime($mtime='')
    {
    }

    /**
     * LbV̍XVԂ擾
     *
     * @access public
     * @param string LbVt@CL[
     * @return int XV(UNIX Time)
     */
    function getModifyTime()
    {
    }

    /**
     * LbVǂݍ
     *
     * @access public
     * @param bool LbVLԂXV
     * @param int ŒXViUNIX timej
     * @return mixed LbVf[^
     */
    function read($modify_time_update=false, $mtime=0)
    {
    }

    /**
     * LbVۑ
     *
     * @access public
     * @param mixed LbVf[^
     * @return bool true: ۑAfalse: ۑG[
     */
    function write($data)
    {
    }

    /**
     * LbV𐮗
     *
     * @access public
     * @param int L(UNIX Time)
     * @return bool true: Afalse: G[
     */
    function clean($mtime='')
    {
    }

    /**
     * LbV폜
     * 
     * @access public
     * @return bool true: 폜Afalse: 폜G[
     */
    function delete()
    {
    }
}

?>
